/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigSet;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.vespa.config.ConfigKey;
import java.lang.reflect.Constructor;

public class ConfigSetSubscription<T extends ConfigInstance>
extends ConfigSubscription<T> {
    private final ConfigSet set;
    private final ConfigKey<T> subKey;

    ConfigSetSubscription(ConfigKey<T> key, ConfigSubscriber subscriber, ConfigSource cset) {
        super(key, subscriber);
        if (!(cset instanceof ConfigSet)) {
            throw new IllegalArgumentException("Source is not a ConfigSet: " + cset);
        }
        this.set = (ConfigSet)cset;
        this.subKey = new ConfigKey(this.configClass, key.getConfigId());
        if (!this.set.contains(this.subKey)) {
            throw new IllegalArgumentException("The given ConfigSet " + this.set + " does not contain a config for " + this.subKey);
        }
        this.setGeneration(0L);
    }

    @Override
    public boolean nextConfig(long timeout) {
        long end = System.currentTimeMillis() + timeout;
        do {
            ConfigInstance myInstance = this.getNewInstance();
            if (this.checkReloaded()) {
                this.updateInstance(myInstance);
                return true;
            }
            if (!myInstance.equals((Object)this.config)) {
                Long l = this.generation;
                Long l2 = this.generation = Long.valueOf(this.generation + 1L);
                this.updateInstance(myInstance);
                return true;
            }
            this.sleep();
        } while (System.currentTimeMillis() < end);
        this.setGenerationChanged(false);
        this.setConfigChanged(false);
        return false;
    }

    private void sleep() {
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("nextConfig aborted", e);
        }
    }

    private void updateInstance(ConfigInstance myInstance) {
        if (!myInstance.equals((Object)this.config)) {
            this.setConfigChanged(true);
        }
        this.setConfig(myInstance);
        this.setGenerationChanged(true);
    }

    @Override
    public boolean subscribe(long timeout) {
        return true;
    }

    public ConfigInstance getNewInstance() {
        try {
            ConfigInstance.Builder builder = this.set.get(this.subKey);
            Constructor<?> constructor = builder.getClass().getDeclaringClass().getConstructor(builder.getClass());
            return (ConfigInstance)constructor.newInstance(builder);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

