/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.buildergen;

import com.google.common.io.Files;
import com.yahoo.config.codegen.DefParser;
import com.yahoo.config.codegen.InnerCNode;
import com.yahoo.config.codegen.JavaClassBuilder;
import com.yahoo.text.StringUtilities;
import com.yahoo.vespa.config.buildergen.ConfigDefinitionClass;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;

public class ConfigDefinition {
    private final String name;
    private final String[] defSchema;
    private final InnerCNode cnode;

    public ConfigDefinition(String name, String[] defSchema) {
        this.name = name;
        this.defSchema = defSchema;
        this.cnode = new DefParser(name, (Reader)new StringReader(StringUtilities.implode((String[])defSchema, (String)"\n"))).getTree();
    }

    public InnerCNode getCNode() {
        return this.cnode;
    }

    public ConfigDefinitionClass generateClass() {
        File tempDir = Files.createTempDir();
        DefParser parser = new DefParser(this.name, (Reader)new StringReader(StringUtilities.implode((String[])this.defSchema, (String)"\n")));
        JavaClassBuilder builder = new JavaClassBuilder(parser.getTree(), parser.getNormalizedDefinition(), tempDir, null);
        String className = builder.className();
        return new ConfigDefinitionClass(className, builder.javaPackage(), builder.getConfigClass(className));
    }
}

