/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.slime.ArrayTraverser;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.ObjectTraverser;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigPayload;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigPayloadBuilder {
    private String value;
    private final Map<String, ConfigPayloadBuilder> objectMap;
    private final Map<String, Array> arrayMap;
    private final Map<String, MapBuilder> mapBuilderMap;
    private final ConfigDefinition configDefinition;

    public ConfigPayloadBuilder() {
        this((ConfigDefinition)null, (String)null);
    }

    public ConfigPayloadBuilder(ConfigDefinition configDefinition) {
        this(configDefinition, null);
    }

    private ConfigPayloadBuilder(String value) {
        this(null, value);
    }

    private ConfigPayloadBuilder(ConfigDefinition configDefinition, String value) {
        this.objectMap = new LinkedHashMap<String, ConfigPayloadBuilder>();
        this.arrayMap = new LinkedHashMap<String, Array>();
        this.mapBuilderMap = new LinkedHashMap<String, MapBuilder>();
        this.value = value;
        this.configDefinition = configDefinition;
    }

    public void setField(String name, String value) {
        this.validateField(name, value);
        this.objectMap.put(name, new ConfigPayloadBuilder(value));
    }

    private void validateField(String name, String value) {
        if (this.configDefinition != null) {
            this.configDefinition.verify(name, value);
        }
    }

    public ConfigPayloadBuilder getObject(String name) {
        ConfigPayloadBuilder p = this.objectMap.get(name);
        if (p == null) {
            this.validateObject(name);
            p = new ConfigPayloadBuilder(this.getStructDef(name));
            this.objectMap.put(name, p);
        }
        return p;
    }

    private ConfigDefinition getStructDef(String name) {
        return this.configDefinition == null ? null : (ConfigDefinition)this.configDefinition.getStructDefs().get(name);
    }

    private void validateObject(String name) {
        if (this.configDefinition != null) {
            this.configDefinition.verify(name);
        }
    }

    public Array getArray(String name) {
        Array a = this.arrayMap.get(name);
        if (a == null) {
            this.validateArray(name);
            a = new Array(this.configDefinition, name);
            this.arrayMap.put(name, a);
        }
        return a;
    }

    private void validateArray(String name) {
        if (this.configDefinition != null) {
            this.configDefinition.verify(name);
        }
    }

    public void resolve(Cursor parent) {
        String name;
        for (Map.Entry<String, ConfigPayloadBuilder> entry : this.objectMap.entrySet()) {
            name = entry.getKey();
            ConfigPayloadBuilder value = entry.getValue();
            if (value.getValue() == null) {
                Cursor childCursor = parent.setObject(name);
                value.resolve(childCursor);
                continue;
            }
            parent.setString(name, value.getValue());
        }
        for (Map.Entry<String, Object> entry : this.arrayMap.entrySet()) {
            Cursor array = parent.setArray(entry.getKey());
            ((Array)entry.getValue()).resolve(array);
        }
        for (Map.Entry<String, Object> entry : this.mapBuilderMap.entrySet()) {
            name = entry.getKey();
            MapBuilder map = (MapBuilder)entry.getValue();
            Cursor cursormap = parent.setObject(name);
            map.resolve(cursormap);
        }
    }

    public ConfigPayloadBuilder override(ConfigPayloadBuilder other) {
        Object value;
        String key;
        this.value = other.value;
        for (Map.Entry<String, ConfigPayloadBuilder> entry : other.objectMap.entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (this.objectMap.containsKey(key)) {
                this.objectMap.put(key, this.objectMap.get(key).override((ConfigPayloadBuilder)value));
                continue;
            }
            this.objectMap.put(key, new ConfigPayloadBuilder((ConfigPayloadBuilder)value));
        }
        for (Map.Entry<String, Object> entry : other.arrayMap.entrySet()) {
            key = entry.getKey();
            value = (Array)entry.getValue();
            if (this.arrayMap.containsKey(key)) {
                this.arrayMap.put(key, this.arrayMap.get(key).override((Array)value));
                continue;
            }
            this.arrayMap.put(key, new Array((Array)value));
        }
        this.mapBuilderMap.putAll(other.mapBuilderMap);
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public MapBuilder getMap(String name) {
        MapBuilder a = this.mapBuilderMap.get(name);
        if (a == null) {
            this.validateMap(name);
            a = new MapBuilder(this.configDefinition, name);
            this.mapBuilderMap.put(name, a);
        }
        return a;
    }

    private void validateMap(String name) {
        if (this.configDefinition != null) {
            this.configDefinition.verify(name);
        }
    }

    public ConfigDefinition getConfigDefinition() {
        return this.configDefinition;
    }

    private ConfigPayloadBuilder(ConfigPayloadBuilder other) {
        this.arrayMap = other.arrayMap;
        this.mapBuilderMap = other.mapBuilderMap;
        this.value = other.value;
        this.objectMap = other.objectMap;
        this.configDefinition = other.configDefinition;
    }

    public ConfigPayloadBuilder(ConfigPayload payload) {
        this(new BuilderDecoder(payload.getSlime()).decode((Inspector)payload.getSlime().get()));
    }

    private static class BuilderDecoder {
        private final Slime slime;

        public BuilderDecoder(Slime slime) {
            this.slime = slime;
        }

        ConfigPayloadBuilder decode(Inspector element) {
            ConfigPayloadBuilder root = new ConfigPayloadBuilder();
            BuilderDecoder.decodeObject(this.slime, root, element);
            return root;
        }

        private static void decodeObject(Slime slime, ConfigPayloadBuilder builder, Inspector element) {
            BuilderObjectTraverser traverser = new BuilderObjectTraverser(slime, builder);
            element.traverse((ObjectTraverser)traverser);
        }

        private static void decode(Slime slime, String name, Inspector inspector, ConfigPayloadBuilder builder) {
            switch (inspector.type()) {
                case STRING: {
                    builder.setField(name, inspector.asString());
                    break;
                }
                case LONG: {
                    builder.setField(name, String.valueOf(inspector.asLong()));
                    break;
                }
                case DOUBLE: {
                    builder.setField(name, String.valueOf(inspector.asDouble()));
                    break;
                }
                case BOOL: {
                    builder.setField(name, String.valueOf(inspector.asBool()));
                    break;
                }
                case OBJECT: {
                    ConfigPayloadBuilder objectBuilder = builder.getObject(name);
                    BuilderDecoder.decodeObject(slime, objectBuilder, inspector);
                    break;
                }
                case ARRAY: {
                    Array array = builder.getArray(name);
                    BuilderDecoder.decodeArray(slime, array, inspector);
                }
            }
        }

        private static void decodeArray(Slime slime, Array array, Inspector inspector) {
            BuilderArrayTraverser traverser = new BuilderArrayTraverser(slime, array);
            inspector.traverse((ArrayTraverser)traverser);
        }

        private static class BuilderArrayTraverser
        implements ArrayTraverser {
            private final Array array;
            private final Slime slime;

            public BuilderArrayTraverser(Slime slime, Array array) {
                this.array = array;
                this.slime = slime;
            }

            public void entry(int idx, Inspector inspector) {
                switch (inspector.type()) {
                    case STRING: {
                        this.array.append(inspector.asString());
                        break;
                    }
                    case OBJECT: {
                        BuilderDecoder.decodeObject(this.slime, this.array.append(), inspector);
                    }
                }
            }
        }

        private static class BuilderObjectTraverser
        implements ObjectTraverser {
            private final ConfigPayloadBuilder builder;
            private final Slime slime;

            public BuilderObjectTraverser(Slime slime, ConfigPayloadBuilder builder) {
                this.slime = slime;
                this.builder = builder;
            }

            public void field(String name, Inspector inspector) {
                BuilderDecoder.decode(this.slime, name, inspector, this.builder);
            }
        }
    }

    public class Array {
        private final Map<Integer, ConfigPayloadBuilder> elements = new LinkedHashMap<Integer, ConfigPayloadBuilder>();
        private ArrayMode mode = ArrayMode.INDEX;
        private final String name;
        private final ConfigDefinition configDefinition;

        public Array(ConfigDefinition configDefinition, String name) {
            this.configDefinition = configDefinition;
            this.name = name;
        }

        public Array(Array other) {
            this.elements.putAll(other.elements);
            this.mode = other.mode;
            this.name = other.name;
            this.configDefinition = other.configDefinition;
        }

        public void append(String value) {
            this.setAppend();
            this.validateArrayElement(this.getArrayDef(this.name), value, this.elements.size());
            ConfigPayloadBuilder p = new ConfigPayloadBuilder(this.getArrayDef(this.name), value);
            this.elements.put(this.elements.size(), p);
        }

        private void validateArrayElement(ConfigDefinition.ArrayDef arrayDef, String value, int index) {
            if (arrayDef != null) {
                arrayDef.verify(value, index);
            }
        }

        private ConfigDefinition.ArrayDef getArrayDef(String name) {
            return this.configDefinition == null ? null : this.configDefinition.getArrayDefs().get(name);
        }

        private ConfigDefinition getInnerArrayDef(String name) {
            return this.configDefinition == null ? null : (ConfigDefinition)this.configDefinition.getInnerArrayDefs().get(name);
        }

        public Collection<ConfigPayloadBuilder> getElements() {
            return this.elements.values();
        }

        public ConfigPayloadBuilder append() {
            this.setAppend();
            ConfigPayloadBuilder p = new ConfigPayloadBuilder(this.getInnerArrayDef(this.name));
            this.elements.put(this.elements.size(), p);
            return p;
        }

        public void set(int index, String value) {
            this.verifyIndex();
            ConfigPayloadBuilder p = new ConfigPayloadBuilder(value);
            this.elements.put(index, p);
        }

        public ConfigPayloadBuilder set(int index) {
            this.verifyIndex();
            ConfigPayloadBuilder p = new ConfigPayloadBuilder(this.getInnerArrayDef(this.name));
            this.elements.put(index, p);
            return p;
        }

        public ConfigPayloadBuilder get(int index) {
            ConfigPayloadBuilder builder = this.elements.get(index);
            if (builder == null) {
                builder = this.mode == ArrayMode.APPEND ? this.append() : this.set(index);
            }
            return builder;
        }

        private void setAppend() {
            if (this.mode == ArrayMode.INDEX && this.elements.size() > 0) {
                throw new IllegalStateException("Cannot append elements to an array in index mode with more than one element");
            }
            this.mode = ArrayMode.APPEND;
        }

        private void verifyIndex() {
            if (this.mode == ArrayMode.APPEND) {
                throw new IllegalStateException("Cannot reference array elements with index once append is done");
            }
        }

        public void resolve(Cursor parent) {
            for (Map.Entry<Integer, ConfigPayloadBuilder> entry : this.elements.entrySet()) {
                ConfigPayloadBuilder child = entry.getValue();
                String childVal = child.getValue();
                if (childVal != null) {
                    parent.addString(childVal);
                    continue;
                }
                Cursor childCursor = parent.addObject();
                child.resolve(childCursor);
            }
        }

        public Array override(Array superior) {
            if (this.mode == ArrayMode.INDEX && superior.mode == ArrayMode.INDEX) {
                this.elements.putAll(superior.elements);
            } else {
                for (ConfigPayloadBuilder builder : superior.elements.values()) {
                    this.append().override(builder);
                }
            }
            return this;
        }
    }

    private static enum ArrayMode {
        INDEX,
        APPEND;

    }

    public class MapBuilder {
        private final Map<String, ConfigPayloadBuilder> elements = new LinkedHashMap<String, ConfigPayloadBuilder>();
        private final ConfigDefinition configDefinition;
        private final String name;

        public MapBuilder(ConfigDefinition configDefinition, String name) {
            this.configDefinition = configDefinition;
            this.name = name;
        }

        public void put(String key, String value) {
            this.elements.put(key, new ConfigPayloadBuilder(this.getLeafMapDef(this.name), value));
        }

        public ConfigPayloadBuilder put(String key) {
            ConfigPayloadBuilder p = new ConfigPayloadBuilder(this.getStructMapDef(this.name));
            this.elements.put(key, p);
            return p;
        }

        public ConfigPayloadBuilder get(String key) {
            ConfigPayloadBuilder builder = this.elements.get(key);
            if (builder == null) {
                builder = this.put(key);
            }
            return builder;
        }

        public void resolve(Cursor parent) {
            for (Map.Entry<String, ConfigPayloadBuilder> entry : this.elements.entrySet()) {
                ConfigPayloadBuilder child = entry.getValue();
                String childVal = child.getValue();
                if (childVal != null) {
                    parent.setString(entry.getKey(), childVal);
                    continue;
                }
                Cursor childCursor = parent.setObject(entry.getKey());
                child.resolve(childCursor);
            }
        }

        private ConfigDefinition.LeafMapDef getLeafMapDef(String name) {
            return this.configDefinition == null ? null : this.configDefinition.getLeafMapDefs().get(name);
        }

        private ConfigDefinition getStructMapDef(String name) {
            return this.configDefinition == null ? null : (ConfigDefinition)this.configDefinition.getStructMapDefs().get(name);
        }

        public Collection<ConfigPayloadBuilder> getElements() {
            return this.elements.values();
        }
    }
}

