/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.ConfigDefinition;
import com.yahoo.vespa.config.ConfigDefinitionKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigDefinitionSet {
    private static final Logger log = Logger.getLogger(ConfigDefinitionSet.class.getName());
    private final Map<ConfigDefinitionKey, ConfigDefinition> defs = new ConcurrentHashMap<ConfigDefinitionKey, ConfigDefinition>();

    public void add(ConfigDefinitionKey key, ConfigDefinition def) {
        log.log((Level)LogLevel.DEBUG, "Adding to set: " + key);
        this.defs.put(key, def);
    }

    public ConfigDefinition get(ConfigDefinitionKey key) {
        log.log((Level)LogLevel.DEBUG, "Getting from set " + this.defs + " for key " + key);
        ConfigDefinition ret = this.defs.get(key);
        if (ret == null) {
            log.log((Level)LogLevel.DEBUG, "Found no def for key " + key + ", trying to find def with same name in default namespace");
            for (Map.Entry<ConfigDefinitionKey, ConfigDefinition> entry : this.defs.entrySet()) {
                if (!key.getName().equals(entry.getKey().getName()) || !entry.getKey().getNamespace().equals("config")) continue;
                return entry.getValue();
            }
        }
        return ret;
    }

    public int size() {
        return this.defs.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ConfigDefinitionKey key : this.defs.keySet()) {
            sb.append(key.toString()).append("\n");
        }
        return sb.toString();
    }
}

