/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigSet;
import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.ConfigSubscriber;
import com.yahoo.config.subscription.DirSource;
import com.yahoo.config.subscription.FileSource;
import com.yahoo.config.subscription.JarSource;
import com.yahoo.config.subscription.RawSource;
import com.yahoo.config.subscription.impl.ConfigSetSubscription;
import com.yahoo.config.subscription.impl.FileConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigSubscription;
import com.yahoo.config.subscription.impl.JarConfigSubscription;
import com.yahoo.config.subscription.impl.RawConfigSubscription;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.protocol.DefContent;
import java.io.File;
import java.util.logging.Logger;

public abstract class ConfigSubscription<T extends ConfigInstance> {
    protected static Logger log = Logger.getLogger(ConfigSubscription.class.getName());
    protected ConfigSubscriber subscriber;
    protected boolean configChanged = false;
    protected boolean generationChanged = false;
    protected volatile T config = null;
    protected Long generation = null;
    protected ConfigKey<T> key;
    protected Class<T> configClass;
    private volatile RuntimeException exception = null;
    private State state = State.OPEN;
    private boolean doReload = false;
    private long reloadedGeneration = -1L;

    ConfigSubscription(ConfigKey<T> key, ConfigSubscriber subscriber) {
        this.key = key;
        this.configClass = key.getConfigClass();
        this.subscriber = subscriber;
    }

    public static <T extends ConfigInstance> ConfigSubscription<T> get(ConfigKey<T> key, ConfigSubscriber subscriber, ConfigSource source, TimingValues timingValues) {
        String configId = key.getConfigId();
        if (source instanceof RawSource || configId.startsWith("raw:")) {
            return ConfigSubscription.getRawSub(key, subscriber, source);
        }
        if (source instanceof FileSource || configId.startsWith("file:")) {
            return ConfigSubscription.getFileSub(key, subscriber, source);
        }
        if (source instanceof DirSource || configId.startsWith("dir:")) {
            return ConfigSubscription.getDirFileSub(key, subscriber, source);
        }
        if (source instanceof JarSource || configId.startsWith("jar:")) {
            return ConfigSubscription.getJarSub(key, subscriber, source);
        }
        if (source instanceof ConfigSet) {
            return new ConfigSetSubscription<T>(key, subscriber, source);
        }
        if (source instanceof ConfigSourceSet) {
            return new JRTConfigSubscription<T>(key, subscriber, source, timingValues);
        }
        throw new IllegalArgumentException("Unknown source type: " + source);
    }

    private static <T extends ConfigInstance> JarConfigSubscription<T> getJarSub(ConfigKey<T> key, ConfigSubscriber subscriber, ConfigSource source) {
        String jarName;
        String path = "config/";
        if (source instanceof JarSource) {
            JarSource js = (JarSource)source;
            jarName = js.getJarFile().getName();
            if (js.getPath() != null) {
                path = js.getPath();
            }
        } else {
            jarName = key.getConfigId().replace("jar:", "").replaceFirst("\\!/.*", "");
            if (key.getConfigId().contains("!/")) {
                path = key.getConfigId().replaceFirst(".*\\!/", "");
            }
        }
        return new JarConfigSubscription<T>(key, subscriber, jarName, path);
    }

    private static <T extends ConfigInstance> ConfigSubscription<T> getFileSub(ConfigKey<T> key, ConfigSubscriber subscriber, ConfigSource source) {
        File file = source instanceof FileSource ? ((FileSource)source).getFile() : new File(key.getConfigId().replace("file:", ""));
        return new FileConfigSubscription<T>(key, subscriber, file);
    }

    private static <T extends ConfigInstance> ConfigSubscription<T> getRawSub(ConfigKey<T> key, ConfigSubscriber subscriber, ConfigSource source) {
        String payload = source instanceof RawSource ? ((RawSource)source).payload : key.getConfigId().replace("raw:", "");
        return new RawConfigSubscription<T>(key, subscriber, payload);
    }

    private static <T extends ConfigInstance> ConfigSubscription<T> getDirFileSub(ConfigKey<T> key, ConfigSubscriber subscriber, ConfigSource source) {
        String dir = key.getConfigId().replace("dir:", "");
        if (source instanceof DirSource) {
            dir = ((DirSource)source).getDir().toString();
        }
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        String name = ConfigSubscription.getConfigFilenameNoVersion(key);
        File file = new File(dir + name);
        if (!file.exists()) {
            throw new IllegalArgumentException("Could not find a config file for '" + key.getName() + "' in '" + dir + "'");
        }
        return new FileConfigSubscription<T>(key, subscriber, file);
    }

    public boolean equals(Object o) {
        if (o instanceof ConfigSubscription) {
            ConfigSubscription other = (ConfigSubscription)o;
            return this.key.equals(other.key) && this.subscriber.equals(other.subscriber);
        }
        return false;
    }

    void setConfigChanged(boolean changed) {
        this.configChanged = changed;
    }

    void setGenerationChanged(boolean genChanged) {
        this.generationChanged = genChanged;
    }

    public void resetChangedFlags() {
        this.setConfigChanged(false);
        this.setGenerationChanged(false);
    }

    public boolean isConfigChanged() {
        return this.configChanged;
    }

    public boolean isGenerationChanged() {
        return this.generationChanged;
    }

    void setConfig(T config) {
        this.config = config;
    }

    public T getConfig() {
        return this.config;
    }

    public Long getGeneration() {
        return this.generation;
    }

    public Class<T> getConfigClass() {
        return this.configClass;
    }

    void setGeneration(Long generation) {
        this.generation = generation;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(this.key.toString());
        s.append(", Current generation: ").append(this.generation).append(", Generation changed: ").append(this.generationChanged).append(", Config changed: ").append(this.configChanged);
        if (this.exception != null) {
            s.append(", Exception: ").append(this.exception);
        }
        return s.toString();
    }

    public ConfigKey<T> getKey() {
        return this.key;
    }

    public abstract boolean nextConfig(long var1);

    public abstract boolean subscribe(long var1);

    public void setException(RuntimeException e) {
        this.exception = e;
    }

    public RuntimeException getException() {
        return this.exception;
    }

    boolean hasException() {
        return this.exception != null;
    }

    public void close() {
        this.state = State.CLOSED;
    }

    State getState() {
        return this.state;
    }

    static <T extends ConfigInstance> String getConfigFilenameNoVersion(ConfigKey<T> key) {
        StringBuilder filename = new StringBuilder(key.getName());
        filename.append(".cfg");
        return filename.toString();
    }

    public synchronized void reload(long generation) {
        this.doReload = true;
        this.reloadedGeneration = generation;
    }

    protected synchronized boolean checkReloaded() {
        if (this.doReload) {
            this.generation = this.reloadedGeneration;
            this.setGenerationChanged(true);
            this.doReload = false;
            return true;
        }
        return false;
    }

    public DefContent getDefContent() {
        return DefContent.fromClass(this.configClass);
    }

    static enum State {
        OPEN,
        CLOSED;

    }
}

