/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy.filedistribution;

import com.yahoo.vespa.config.proxy.filedistribution.UrlDownloadRpcServer;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.maintenance.FileDistributionCleanup;
import java.io.File;
import java.time.Clock;
import java.time.Duration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class CachedFilesMaintainer
implements Runnable {
    private static final Logger log = Logger.getLogger(CachedFilesMaintainer.class.getName());
    private static final File defaultUrlDownloadDir = UrlDownloadRpcServer.downloadDir;
    private static final File defaultFileReferencesDownloadDir = FileDownloader.defaultDownloadDirectory;
    private static final Duration defaultDurationToKeepFiles = Duration.ofDays(20L);
    private static final int defaultKeepCount = 20;
    private final File urlDownloadDir;
    private final File fileReferencesDownloadDir;
    private final Duration durationToKeepFiles;
    private final FileDistributionCleanup cleanup;
    private final int keepCount;

    CachedFilesMaintainer() {
        this(defaultFileReferencesDownloadDir, defaultUrlDownloadDir, defaultDurationToKeepFiles, Clock.systemUTC(), 20);
    }

    CachedFilesMaintainer(File fileReferencesDownloadDir, File urlDownloadDir, Duration durationToKeepFiles, Clock clock, int keepCount) {
        this.fileReferencesDownloadDir = fileReferencesDownloadDir;
        this.urlDownloadDir = urlDownloadDir;
        this.durationToKeepFiles = durationToKeepFiles;
        this.cleanup = new FileDistributionCleanup(clock);
        this.keepCount = keepCount;
    }

    @Override
    public void run() {
        try {
            this.deleteUnusedFiles(this.fileReferencesDownloadDir);
            this.deleteUnusedFiles(this.urlDownloadDir);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Deleting unused files failed. ", t);
        }
    }

    private void deleteUnusedFiles(File directory) {
        this.cleanup.deleteUnusedFileReferences(directory, this.durationToKeepFiles, this.keepCount, Set.of());
    }
}

