/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import java.util.HashSet;
import java.util.Set;

class Mode {
    private final ModeName mode;

    Mode(ModeName modeName) {
        this.mode = modeName;
    }

    Mode(String modeString) {
        switch (modeString.toLowerCase()) {
            case "default": {
                this.mode = ModeName.DEFAULT;
                break;
            }
            case "memorycache": {
                this.mode = ModeName.MEMORYCACHE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized mode '" + modeString + "' supplied. Legal modes are '" + String.valueOf(Mode.modes()) + "'");
            }
        }
    }

    ModeName getMode() {
        return this.mode;
    }

    boolean isDefault() {
        return this.mode.equals((Object)ModeName.DEFAULT);
    }

    boolean requiresConfigSource() {
        return this.mode.equals((Object)ModeName.DEFAULT);
    }

    static Set<String> modes() {
        HashSet<String> modes = new HashSet<String>();
        for (ModeName mode : ModeName.values()) {
            modes.add(mode.name().toLowerCase());
        }
        return modes;
    }

    String name() {
        return this.mode.name().toLowerCase();
    }

    public String toString() {
        return this.mode.name().toLowerCase();
    }

    static enum ModeName {
        DEFAULT,
        MEMORYCACHE;

    }
}

