/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResponseHandler {
    private final Optional<AtomicLong> sentResponses;
    private static final Logger log = Logger.getLogger(ResponseHandler.class.getName());

    public ResponseHandler() {
        this(false);
    }

    ResponseHandler(boolean trackResponses) {
        this.sentResponses = trackResponses ? Optional.of(new AtomicLong()) : Optional.empty();
    }

    public void returnOkResponse(JRTServerConfigRequest request, RawConfig config) {
        request.getRequestTrace().trace(6, "Config proxy returnOkResponse()");
        request.addOkResponse(config.getPayload(), config.getGeneration(), config.applyOnRestart(), config.getPayloadChecksums());
        log.log(Level.FINE, () -> "Return response: " + request.getShortDescription() + ",config checksums=" + config.getPayloadChecksums() + ",generation=" + config.getGeneration() + ",applyOnRestart=" + config.applyOnRestart());
        log.log(Level.FINEST, () -> "Config payload in response for " + request.getShortDescription() + ":" + config.getPayload());
        try {
            request.getRequest().returnRequest();
        }
        catch (IllegalStateException e) {
            log.log(Level.FINE, () -> "Something bad happened when sending response for '" + request.getShortDescription() + "':" + e.getMessage());
        }
        this.sentResponses.ifPresent(AtomicLong::getAndIncrement);
    }

    public void returnErrorResponse(JRTServerConfigRequest request, int errorCode, String message) {
        request.getRequestTrace().trace(6, "Config proxy returnErrorResponse()");
        request.addErrorResponse(errorCode, message);
        request.getRequest().returnRequest();
    }

    public long sentResponses() {
        return this.sentResponses.map(AtomicLong::get).orElse(0L);
    }
}

