/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy.filedistribution;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.S3Object;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import com.yahoo.vespa.config.proxy.filedistribution.Downloader;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;

public class S3Downloader
implements Downloader {
    private final AmazonS3 s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(System.getenv("VESPA_CLOUD_NATIVE_REGION"))).withCredentials((AWSCredentialsProvider)new CredentialsProvider())).build();

    S3Downloader() {
    }

    @Override
    public Optional<File> downloadFile(String url, File targetDir) throws IOException {
        AmazonS3URI s3URI = new AmazonS3URI(url);
        S3Object s3Object = this.s3Client.getObject(s3URI.getBucket(), s3URI.getKey());
        File file = new File(targetDir, this.fileName());
        Files.copy((InputStream)s3Object.getObjectContent(), file.toPath(), new CopyOption[0]);
        return Optional.of(file);
    }

    private static class CredentialsProvider
    implements AWSCredentialsProvider {
        private static final String DEFAULT_CREDENTIALS_PATH = Defaults.getDefaults().underVespaHome("var/vespa/aws/credentials.json");
        private final Path credentialsPath = Path.of(DEFAULT_CREDENTIALS_PATH, new String[0]);

        public AWSCredentials getCredentials() {
            return this.readCredentials();
        }

        public void refresh() {
            this.readCredentials();
        }

        private AWSSessionCredentials readCredentials() {
            try {
                Slime slime = SlimeUtils.jsonToSlime((byte[])Files.readAllBytes(this.credentialsPath));
                Cursor cursor = slime.get();
                String accessKey = cursor.field("awsAccessKey").asString();
                String secretKey = cursor.field("awsSecretKey").asString();
                String sessionToken = cursor.field("sessionToken").asString();
                return new BasicSessionCredentials(accessKey, secretKey, sessionToken);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

