/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy.filedistribution;

import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Value;
import com.yahoo.security.tls.Capability;
import com.yahoo.text.Utf8;
import com.yahoo.vespa.config.proxy.filedistribution.RequestTracker;
import com.yahoo.vespa.defaults.Defaults;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jpountz.xxhash.XXHashFactory;

class UrlDownloadRpcServer {
    private static final Logger log = Logger.getLogger(UrlDownloadRpcServer.class.getName());
    private static final String CONTENTS_FILE_NAME = "contents";
    static final File defaultDownloadDirectory = new File(Defaults.getDefaults().underVespaHome("var/db/vespa/download"));
    private final File rootDownloadDir;
    private final ExecutorService executor = Executors.newFixedThreadPool(Math.max(8, Runtime.getRuntime().availableProcessors()), (ThreadFactory)new DaemonThreadFactory("Rpc URL download executor"));

    UrlDownloadRpcServer(Supervisor supervisor) {
        this.rootDownloadDir = defaultDownloadDirectory;
        supervisor.addMethod(new Method("url.waitFor", "s", "s", this::download).requireCapabilities(new Capability[]{Capability.CONFIGPROXY__FILEDISTRIBUTION_API}).methodDesc("get path to url download").paramDesc(0, "url", "url").returnDesc(0, "path", "path to file"));
    }

    void close() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void download(Request req) {
        req.detach();
        this.executor.execute(() -> this.downloadFile(req));
    }

    private void downloadFile(Request req) {
        String url = req.parameters().get(0).asString();
        File downloadDir = new File(this.rootDownloadDir, UrlDownloadRpcServer.urlToDirName(url));
        if (UrlDownloadRpcServer.alreadyDownloaded(downloadDir)) {
            log.log(Level.INFO, "URL '" + url + "' already downloaded");
            req.returnValues().add((Value)new StringValue(new File(downloadDir, CONTENTS_FILE_NAME).getAbsolutePath()));
            req.returnRequest();
            return;
        }
        try {
            URL website = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)website.openConnection();
            if (connection.getResponseCode() == 200) {
                log.log(Level.INFO, "Downloading URL '" + url + "'");
                UrlDownloadRpcServer.downloadFile(req, connection, downloadDir);
            } else {
                log.log(Level.SEVERE, "Download of URL '" + url + "' got server response: " + connection.getResponseCode());
                req.setError(65539, String.valueOf(connection.getResponseCode()));
            }
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Download of URL '" + url + "' failed, got exception: " + e.getMessage());
            req.setError(65538, "Download of URL '" + url + "' internal error: " + e.getMessage());
        }
        req.returnRequest();
    }

    private static void downloadFile(Request req, HttpURLConnection connection, File downloadDir) throws IOException {
        long start = System.currentTimeMillis();
        String url = connection.getURL().toString();
        Files.createDirectories(downloadDir.toPath(), new FileAttribute[0]);
        File contentsPath = new File(downloadDir, CONTENTS_FILE_NAME);
        try (ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());
             FileOutputStream fos = new FileOutputStream(contentsPath.getAbsolutePath());){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            if (contentsPath.exists() && contentsPath.length() > 0L) {
                new RequestTracker().trackRequest(downloadDir);
                req.returnValues().add((Value)new StringValue(contentsPath.getAbsolutePath()));
                log.log(Level.FINE, () -> "URL '" + url + "' available at " + contentsPath);
                log.log(Level.INFO, String.format("Download of URL '%s' done in %.3f seconds", url, (double)(System.currentTimeMillis() - start) / 1000.0));
            } else {
                log.log(Level.SEVERE, "Downloaded URL '" + url + "' not found, returning error");
                req.setError(65537, "Downloaded '" + url + "' not found");
            }
        }
    }

    private static String urlToDirName(String uri) {
        return String.valueOf(XXHashFactory.fastestJavaInstance().hash64().hash(ByteBuffer.wrap(Utf8.toBytes((String)uri)), 0L));
    }

    private static boolean alreadyDownloaded(File downloadDir) {
        File contents = new File(downloadDir, CONTENTS_FILE_NAME);
        return contents.exists() && contents.length() > 0L;
    }
}

