/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy.filedistribution;

import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.jrt.Supervisor;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.proxy.filedistribution.FileDistributionRpcServer;
import com.yahoo.vespa.config.proxy.filedistribution.FileReferencesAndDownloadsMaintainer;
import com.yahoo.vespa.config.proxy.filedistribution.UrlDownloadRpcServer;
import com.yahoo.vespa.filedistribution.FileDistributionConnectionPool;
import com.yahoo.vespa.filedistribution.FileDownloader;
import com.yahoo.vespa.filedistribution.FileReferenceData;
import java.time.Duration;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class FileDistributionAndUrlDownload {
    private final FileDistributionRpcServer fileDistributionRpcServer;
    private final UrlDownloadRpcServer urlDownloadRpcServer;
    private final FileReferencesAndDownloadsMaintainer maintainer;

    public FileDistributionAndUrlDownload(Supervisor supervisor, ConfigSourceSet source) {
        this.fileDistributionRpcServer = new FileDistributionRpcServer(supervisor, this.createDownloader(supervisor, source));
        this.urlDownloadRpcServer = new UrlDownloadRpcServer(supervisor);
        this.maintainer = new FileReferencesAndDownloadsMaintainer();
    }

    public void close() {
        this.fileDistributionRpcServer.close();
        this.urlDownloadRpcServer.close();
        this.maintainer.close();
    }

    private FileDownloader createDownloader(Supervisor supervisor, ConfigSourceSet source) {
        return new FileDownloader((ConnectionPool)new FileDistributionConnectionPool(source, supervisor), supervisor, Duration.ofMinutes(5L), this.acceptedCompressionTypes());
    }

    private Set<FileReferenceData.CompressionType> acceptedCompressionTypes() {
        Set<Object> acceptedCompressionTypes = Set.of(FileReferenceData.CompressionType.gzip, FileReferenceData.CompressionType.lz4, FileReferenceData.CompressionType.zstd);
        String env = System.getenv("VESPA_FILE_DISTRIBUTION_ACCEPTED_COMPRESSION_TYPES");
        if (env != null && !env.isEmpty()) {
            String[] types = env.split(",");
            acceptedCompressionTypes = Arrays.stream(types).map(FileReferenceData.CompressionType::valueOf).collect(Collectors.toSet());
        }
        return acceptedCompressionTypes;
    }
}

