/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.config.subscription.ConfigSource;
import com.yahoo.config.subscription.ConfigSourceSet;
import com.yahoo.config.subscription.impl.GenericConfigHandle;
import com.yahoo.config.subscription.impl.GenericConfigSubscriber;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.protect.Process;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.yolean.Exceptions;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Subscriber {
    private static final Logger log = Logger.getLogger(Subscriber.class.getName());
    private final RawConfig config;
    private final ConfigSourceSet configSourceSet;
    private final TimingValues timingValues;
    private final GenericConfigSubscriber subscriber;
    private GenericConfigHandle handle;

    Subscriber(RawConfig config, ConfigSourceSet configSourceSet, TimingValues timingValues, JRTConfigRequester requester) {
        this.config = config;
        this.configSourceSet = configSourceSet;
        this.timingValues = timingValues;
        this.subscriber = new GenericConfigSubscriber(Map.of(configSourceSet, requester));
    }

    void subscribe() {
        ConfigKey key = this.config.getKey();
        this.handle = this.subscriber.subscribe(new ConfigKey(key.getName(), key.getConfigId(), key.getNamespace()), this.config.getDefContent(), (ConfigSource)this.configSourceSet, this.timingValues);
    }

    public Optional<RawConfig> nextGeneration() {
        try {
            if (this.subscriber.nextGeneration(0L, true)) {
                return Optional.of(this.handle.getRawConfig());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Got exception: " + Exceptions.toMessageString((Throwable)e));
        }
        catch (Throwable e) {
            Process.logAndDie((String)("Got error, exiting: " + Exceptions.toMessageString((Throwable)e)));
        }
        return Optional.empty();
    }

    public void cancel() {
        if (this.subscriber != null) {
            this.subscriber.close();
        }
    }

    boolean isClosed() {
        return this.subscriber.isClosed();
    }
}

