/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.protect.Process;
import com.yahoo.vespa.config.ConfigCacheKey;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.proxy.DelayedResponse;
import com.yahoo.vespa.config.proxy.DelayedResponses;
import com.yahoo.vespa.config.proxy.MemoryCache;
import com.yahoo.vespa.config.proxy.RpcServer;
import com.yahoo.yolean.Exceptions;
import java.util.concurrent.Delayed;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DelayedResponseHandler
implements Runnable {
    private static final Logger log = Logger.getLogger(DelayedResponseHandler.class.getName());
    private final DelayedResponses delayedResponses;
    private final MemoryCache memoryCache;
    private final RpcServer rpcServer;

    DelayedResponseHandler(DelayedResponses delayedResponses, MemoryCache memoryCache, RpcServer rpcServer) {
        this.delayedResponses = delayedResponses;
        this.memoryCache = memoryCache;
        this.rpcServer = rpcServer;
    }

    @Override
    public void run() {
        this.checkDelayedResponses();
    }

    void checkDelayedResponses() {
        try {
            DelayedResponse response;
            long start = System.currentTimeMillis();
            log.log(Level.FINEST, () -> "Running DelayedResponseHandler. There are " + this.delayedResponses.size() + " delayed responses. First one is " + (Delayed)this.delayedResponses.responses().peek());
            AtomicInteger i = new AtomicInteger(0);
            while ((response = (DelayedResponse)this.delayedResponses.responses().poll()) != null) {
                JRTServerConfigRequest request = response.getRequest();
                ConfigCacheKey cacheKey = new ConfigCacheKey(request.getConfigKey(), request.getConfigKey().getMd5());
                RawConfig config = this.memoryCache.get(cacheKey);
                if (config != null) {
                    this.rpcServer.returnOkResponse(request, config);
                    i.incrementAndGet();
                    continue;
                }
                log.log(Level.WARNING, "Timed out (timeout " + request.getTimeout() + ") getting config " + request.getConfigKey() + ", will retry");
            }
            log.log(Level.FINEST, () -> "Finished running DelayedResponseHandler. " + i.get() + " delayed responses sent in " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Got exception in DelayedResponseHandler: " + Exceptions.toMessageString((Throwable)e));
        }
        catch (Throwable e) {
            Process.logAndDie((String)("Got error in DelayedResponseHandler, exiting: " + Exceptions.toMessageString((Throwable)e)));
        }
    }
}

