/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.log.LogLevel;
import com.yahoo.log.event.Event;
import com.yahoo.vespa.config.proxy.ProxyServer;
import java.util.logging.Level;

class ConfigProxyStatistics
implements Runnable {
    static final long defaultEventInterval = 300L;
    private final long eventInterval;
    private boolean stopped;
    private long lastRun = System.currentTimeMillis();
    private long rpcRequests = 0L;
    private long processedRequests = 0L;
    private long errors = 0L;
    private long delayedResponses = 0L;

    ConfigProxyStatistics() {
        this(300L);
    }

    ConfigProxyStatistics(long eventInterval) {
        this.eventInterval = eventInterval;
    }

    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                ProxyServer.log.log(LogLevel.WARNING, e.getMessage());
            }
            if (this.stopped) {
                return;
            }
            ProxyServer.log.log((Level)LogLevel.SPAM, "Running ConfigProxyStatistics");
            if (System.currentTimeMillis() - this.lastRun <= this.eventInterval * 1000L) continue;
            this.lastRun = System.currentTimeMillis();
            this.sendEvents();
        }
    }

    private void sendEvents() {
        Event.count((String)"rpc_requests", (long)this.rpcRequests());
        Event.count((String)"processed_messages", (long)this.processedRequests());
        Event.count((String)"errors", (long)this.errors());
        Event.value((String)"delayed_responses", (double)this.delayedResponses());
    }

    void stop() {
        this.stopped = true;
    }

    Long getEventInterval() {
        return this.eventInterval;
    }

    void incRpcRequests() {
        ++this.rpcRequests;
    }

    void incProcessedRequests() {
        ++this.processedRequests;
    }

    void incErrorCount() {
        ++this.errors;
    }

    long processedRequests() {
        return this.processedRequests;
    }

    long rpcRequests() {
        return this.rpcRequests;
    }

    long errors() {
        return this.errors;
    }

    long delayedResponses() {
        return this.delayedResponses;
    }

    void delayedResponses(long count) {
        this.delayedResponses = count;
    }

    void decDelayedResponses() {
        --this.delayedResponses;
    }
}

