/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy.filedistribution;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.FileReference;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.StringValue;
import com.yahoo.jrt.Value;
import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.Connection;
import com.yahoo.vespa.config.ConnectionPool;
import com.yahoo.vespa.config.proxy.filedistribution.FileReceiver;
import com.yahoo.vespa.config.proxy.filedistribution.FileReferenceDownload;
import java.io.File;
import java.time.Duration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class FileReferenceDownloader {
    private static final Logger log = Logger.getLogger(FileReferenceDownloader.class.getName());
    private static final Duration rpcTimeout = Duration.ofSeconds(10L);
    private final ExecutorService downloadExecutor = Executors.newFixedThreadPool(10, (ThreadFactory)new DaemonThreadFactory("filereference downloader"));
    private ExecutorService readFromQueueExecutor = Executors.newFixedThreadPool(1, (ThreadFactory)new DaemonThreadFactory("filereference download queue"));
    private final ConnectionPool connectionPool;
    private final ConcurrentLinkedQueue<FileReferenceDownload> downloadQueue = new ConcurrentLinkedQueue();
    private final Map<FileReference, FileReferenceDownload> downloads = new LinkedHashMap<FileReference, FileReferenceDownload>();
    private final Map<FileReference, Double> downloadStatus = new HashMap<FileReference, Double>();
    private final Duration downloadTimeout;
    private final FileReceiver fileReceiver;

    FileReferenceDownloader(File downloadDirectory, ConnectionPool connectionPool, Duration timeout) {
        this.connectionPool = connectionPool;
        this.downloadTimeout = timeout;
        this.readFromQueueExecutor.submit(this::readFromQueue);
        this.fileReceiver = new FileReceiver(connectionPool.getSupervisor(), this, downloadDirectory);
    }

    private synchronized Optional<File> startDownload(FileReference fileReference, Duration timeout, FileReferenceDownload fileReferenceDownload) throws ExecutionException, InterruptedException, TimeoutException {
        this.downloads.put(fileReference, fileReferenceDownload);
        this.setDownloadStatus(fileReference.value(), 0.0);
        if (this.startDownloadRpc(fileReference)) {
            return (Optional)fileReferenceDownload.future().get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        fileReferenceDownload.future().setException((Throwable)new RuntimeException("Failed getting file"));
        this.downloads.remove(fileReference);
        return Optional.empty();
    }

    synchronized void addToDownloadQueue(FileReferenceDownload fileReferenceDownload) {
        this.downloadQueue.add(fileReferenceDownload);
    }

    void receiveFile(FileReference fileReference, String filename, byte[] content, long xxHash) {
        this.fileReceiver.receiveFile(fileReference, filename, content, xxHash);
    }

    synchronized Set<FileReference> queuedDownloads() {
        return this.downloadQueue.stream().map(FileReferenceDownload::fileReference).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void readFromQueue() {
        while (true) {
            FileReferenceDownload fileReferenceDownload;
            if ((fileReferenceDownload = this.downloadQueue.poll()) == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            log.log(LogLevel.INFO, "Polling queue, found file reference '" + fileReferenceDownload.fileReference().value() + "' to download");
            this.downloadExecutor.submit(() -> this.startDownload(fileReferenceDownload.fileReference(), this.downloadTimeout, fileReferenceDownload));
        }
    }

    void completedDownloading(FileReference fileReference, File file) {
        if (this.downloads.containsKey(fileReference)) {
            this.downloads.get(fileReference).future().set(Optional.of(file));
        }
        this.downloadStatus.put(fileReference, 100.0);
    }

    private boolean startDownloadRpc(FileReference fileReference) throws ExecutionException, InterruptedException {
        Connection connection = this.connectionPool.getCurrent();
        Request request = new Request("filedistribution.serveFile");
        request.parameters().add((Value)new StringValue(fileReference.value()));
        this.execute(request, connection);
        if (this.validateResponse(request)) {
            log.log((Level)LogLevel.DEBUG, "Request callback, OK. Req: " + request + "\nSpec: " + connection);
            if (request.returnValues().get(0).asInt32() == 0) {
                log.log(LogLevel.INFO, "Found file reference '" + fileReference.value() + "' available at " + connection.getAddress());
            } else {
                log.log(LogLevel.INFO, "File reference '" + fileReference.value() + "' not found for " + connection.getAddress());
            }
            return true;
        }
        log.log(LogLevel.WARNING, "Request failed. Req: " + request + "\nSpec: " + connection.getAddress());
        connection.setError(request.errorCode());
        return false;
    }

    synchronized boolean isDownloading(FileReference fileReference) {
        return this.downloads.containsKey(fileReference);
    }

    synchronized ListenableFuture<Optional<File>> addDownloadListener(FileReference fileReference, Runnable runnable) {
        FileReferenceDownload fileReferenceDownload = this.downloads.get(fileReference);
        fileReferenceDownload.future().addListener(runnable, (Executor)this.downloadExecutor);
        return fileReferenceDownload.future();
    }

    private void execute(Request request, Connection connection) {
        connection.invokeSync(request, (double)rpcTimeout.getSeconds());
    }

    private boolean validateResponse(Request request) {
        if (request.isError()) {
            return false;
        }
        if (request.returnValues().size() == 0) {
            return false;
        }
        if (!request.checkReturnTypes("is")) {
            log.log(LogLevel.WARNING, "Invalid return types for response: " + request.errorMessage());
            return false;
        }
        return true;
    }

    double downloadStatus(String file) {
        return this.downloadStatus.getOrDefault(new FileReference(file), 0.0);
    }

    void setDownloadStatus(String file, double percentageDownloaded) {
        this.downloadStatus.put(new FileReference(file), percentageDownloaded);
    }

    Map<FileReference, Double> downloadStatus() {
        return ImmutableMap.copyOf(this.downloadStatus);
    }
}

