/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import java.util.HashSet;
import java.util.Set;

class Mode {
    private final ModeName mode;

    public Mode() {
        this(ModeName.DEFAULT);
    }

    public Mode(ModeName modeName) {
        this.mode = modeName;
    }

    public Mode(String modeString) {
        switch (modeString.toLowerCase()) {
            case "": {
                this.mode = ModeName.DEFAULT;
                break;
            }
            case "default": {
                this.mode = ModeName.DEFAULT;
                break;
            }
            case "memorycache": {
                this.mode = ModeName.MEMORYCACHE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized mode'" + modeString + "' supplied");
            }
        }
    }

    public ModeName getMode() {
        return this.mode;
    }

    public boolean isDefault() {
        return this.mode.equals((Object)ModeName.DEFAULT);
    }

    public boolean isMemoryCache() {
        return this.mode.equals((Object)ModeName.MEMORYCACHE);
    }

    public boolean requiresConfigSource() {
        return this.mode.equals((Object)ModeName.DEFAULT);
    }

    public static boolean validModeName(String modeString) {
        return modeString != null && Mode.modes().contains(modeString);
    }

    static Set<String> modes() {
        HashSet<String> modes = new HashSet<String>();
        for (ModeName mode : ModeName.values()) {
            modes.add(mode.name().toLowerCase());
        }
        return modes;
    }

    public String name() {
        return this.mode.name().toLowerCase();
    }

    public String toString() {
        return this.mode.name().toLowerCase();
    }

    static enum ModeName {
        DEFAULT,
        MEMORYCACHE;

    }
}

