/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.proxy;

import com.yahoo.log.LogLevel;
import com.yahoo.vespa.config.RawConfig;
import com.yahoo.vespa.config.protocol.JRTServerConfigRequest;
import com.yahoo.vespa.config.proxy.ConfigProxyStatistics;
import com.yahoo.vespa.config.proxy.DelayedResponse;
import com.yahoo.vespa.config.proxy.DelayedResponses;
import com.yahoo.vespa.config.proxy.RpcServer;
import java.util.concurrent.DelayQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

class ClientUpdater {
    private static final Logger log = Logger.getLogger(ClientUpdater.class.getName());
    private final ConfigProxyStatistics statistics;
    private final RpcServer rpcServer;
    private final DelayedResponses delayedResponses;

    ClientUpdater(RpcServer rpcServer, ConfigProxyStatistics statistics, DelayedResponses delayedResponses) {
        this.rpcServer = rpcServer;
        this.statistics = statistics;
        this.delayedResponses = delayedResponses;
    }

    void updateSubscribers(RawConfig config) {
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "Config updated for " + config.getKey() + "," + config.getGeneration());
        }
        this.sendResponse(config);
    }

    private void sendResponse(RawConfig config) {
        if (config.isError()) {
            this.statistics.incErrorCount();
        }
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "Sending response for " + config.getKey() + "," + config.getGeneration());
        }
        DelayQueue<DelayedResponse> responseDelayQueue = this.delayedResponses.responses();
        if (log.isLoggable((Level)LogLevel.SPAM)) {
            log.log((Level)LogLevel.SPAM, "Delayed response queue: " + responseDelayQueue);
        }
        if (responseDelayQueue.size() == 0) {
            log.log((Level)LogLevel.DEBUG, "There exists no matching element on delayed response queue for " + config.getKey());
            return;
        }
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "Delayed response queue has " + responseDelayQueue.size() + " elements");
        }
        DelayedResponse[] responses = new DelayedResponse[1];
        responses = responseDelayQueue.toArray(responses);
        boolean found = false;
        if (responses.length > 0) {
            for (DelayedResponse response : responses) {
                JRTServerConfigRequest request = response.getRequest();
                if (!request.getConfigKey().equals((Object)config.getKey())) continue;
                if (!this.delayedResponses.remove(response)) {
                    if (!log.isLoggable((Level)LogLevel.DEBUG)) continue;
                    log.log((Level)LogLevel.DEBUG, "Could not remove " + config.getKey() + " from delayed delayedResponses queue, already removed");
                    continue;
                }
                found = true;
                if (log.isLoggable((Level)LogLevel.DEBUG)) {
                    log.log((Level)LogLevel.DEBUG, "Call returnOkResponse for " + config.getKey() + "," + config.getGeneration());
                }
                this.rpcServer.returnOkResponse(request, config);
            }
        }
        if (!found) {
            log.log((Level)LogLevel.DEBUG, "Found no recipient for " + config.getKey() + " in delayed response queue");
        }
        if (log.isLoggable((Level)LogLevel.DEBUG)) {
            log.log((Level)LogLevel.DEBUG, "Finished updating config for " + config.getKey() + "," + config.getGeneration());
        }
    }
}

