/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import ai.vespa.validation.PatternedStringWrapper;
import java.util.regex.Pattern;

public class CloudAccount
extends PatternedStringWrapper<CloudAccount> {
    private static final String EMPTY = "";
    private static final String AWS_ACCOUNT_ID = "[0-9]{12}";
    private static final String GCP_PROJECT_ID = "[a-z][a-z0-9-]{4,28}[a-z0-9]";
    public static final CloudAccount empty = new CloudAccount("", "", "cloud account");

    private CloudAccount(String value, String regex, String description) {
        super(value, Pattern.compile("^(" + regex + ")$"), description);
    }

    public boolean isUnspecified() {
        return this.equals((Object)empty);
    }

    public static CloudAccount from(String cloudAccount) {
        return switch (cloudAccount) {
            case EMPTY, "default" -> empty;
            default -> new CloudAccount(cloudAccount, "[0-9]{12}|[a-z][a-z0-9-]{4,28}[a-z0-9]", "cloud account");
        };
    }

    public String toString() {
        return this.isUnspecified() ? "unspecified account" : "account '" + this.value() + "'";
    }
}

