/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import ai.vespa.validation.PatternedStringWrapper;
import java.util.regex.Pattern;

public class CloudAccount
extends PatternedStringWrapper<CloudAccount> {
    public static final CloudAccount empty = new CloudAccount("");

    private CloudAccount(String value) {
        super(value, Pattern.compile("^([0-9]{12})?$"), "cloud account");
    }

    public boolean isUnspecified() {
        return this.equals((Object)empty);
    }

    public static CloudAccount from(String cloudAccount) {
        return switch (cloudAccount) {
            case "", "default" -> empty;
            default -> new CloudAccount(cloudAccount);
        };
    }

    public String toString() {
        return this.isUnspecified() ? "unspecified account" : "account '" + this.value() + "'";
    }
}

