/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.Objects;
import java.util.Optional;

public class NodeResources {
    private static final double cpuUnitCost = 0.11;
    private static final double memoryUnitCost = 0.011;
    private static final double diskUnitCost = 4.0E-4;
    private static final double gpuUnitCost = 0.0;
    private static final NodeResources zero = new NodeResources(0.0, 0.0, 0.0, 0.0);
    private static final NodeResources unspecified = new NodeResources(0.0, 0.0, 0.0, 0.0);
    private final double vcpu;
    private final double memoryGb;
    private final double diskGb;
    private final double bandwidthGbps;
    private final GpuResources gpuResources;
    private final DiskSpeed diskSpeed;
    private final StorageType storageType;
    private final Architecture architecture;

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps) {
        this(vcpu, memoryGb, diskGb, bandwidthGbps, DiskSpeed.getDefault());
    }

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps, DiskSpeed diskSpeed) {
        this(vcpu, memoryGb, diskGb, bandwidthGbps, diskSpeed, StorageType.getDefault(), Architecture.getDefault(), GpuResources.getDefault());
    }

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps, DiskSpeed diskSpeed, StorageType storageType) {
        this(vcpu, memoryGb, diskGb, bandwidthGbps, diskSpeed, storageType, Architecture.getDefault(), GpuResources.getDefault());
    }

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps, DiskSpeed diskSpeed, StorageType storageType, Architecture architecture) {
        this(vcpu, memoryGb, diskGb, bandwidthGbps, diskSpeed, storageType, architecture, GpuResources.getDefault());
    }

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps, DiskSpeed diskSpeed, StorageType storageType, Architecture architecture, GpuResources gpuResources) {
        this.vcpu = NodeResources.validate(vcpu, "vcpu");
        this.memoryGb = NodeResources.validate(memoryGb, "memory");
        this.diskGb = NodeResources.validate(diskGb, "disk");
        this.bandwidthGbps = NodeResources.validate(bandwidthGbps, "bandwidth");
        this.gpuResources = gpuResources;
        this.diskSpeed = diskSpeed;
        this.storageType = storageType;
        this.architecture = architecture;
    }

    public double vcpu() {
        return this.vcpu;
    }

    public double memoryGb() {
        return this.memoryGb;
    }

    public double diskGb() {
        return this.diskGb;
    }

    public double bandwidthGbps() {
        return this.bandwidthGbps;
    }

    public DiskSpeed diskSpeed() {
        return this.diskSpeed;
    }

    public StorageType storageType() {
        return this.storageType;
    }

    public Architecture architecture() {
        return this.architecture;
    }

    public GpuResources gpuResources() {
        return this.gpuResources;
    }

    public double cost() {
        return this.vcpu * 0.11 + this.memoryGb * 0.011 + this.diskGb * 4.0E-4 + this.gpuResources.totalMemory() * 0.0;
    }

    public NodeResources withVcpu(double vcpu) {
        this.ensureSpecified();
        if (vcpu == this.vcpu) {
            return this;
        }
        return new NodeResources(vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, this.architecture, this.gpuResources);
    }

    public NodeResources withMemoryGb(double memoryGb) {
        this.ensureSpecified();
        if (memoryGb == this.memoryGb) {
            return this;
        }
        return new NodeResources(this.vcpu, memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, this.architecture, this.gpuResources);
    }

    public NodeResources withDiskGb(double diskGb) {
        this.ensureSpecified();
        if (diskGb == this.diskGb) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, this.architecture, this.gpuResources);
    }

    public NodeResources withBandwidthGbps(double bandwidthGbps) {
        this.ensureSpecified();
        if (bandwidthGbps == this.bandwidthGbps) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, bandwidthGbps, this.diskSpeed, this.storageType, this.architecture, this.gpuResources);
    }

    public NodeResources with(DiskSpeed diskSpeed) {
        this.ensureSpecified();
        if (diskSpeed == this.diskSpeed) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, diskSpeed, this.storageType, this.architecture, this.gpuResources);
    }

    public NodeResources with(StorageType storageType) {
        this.ensureSpecified();
        if (storageType == this.storageType) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, storageType, this.architecture, this.gpuResources);
    }

    public NodeResources with(Architecture architecture) {
        this.ensureSpecified();
        if (architecture == this.architecture) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, architecture, this.gpuResources);
    }

    public NodeResources with(GpuResources gpuResources) {
        this.ensureSpecified();
        if (this.gpuResources.equals(gpuResources)) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, this.architecture, gpuResources);
    }

    public NodeResources justNumbers() {
        if (this.isUnspecified()) {
            return NodeResources.unspecified();
        }
        return this.with(DiskSpeed.any).with(StorageType.any).with(Architecture.any);
    }

    public NodeResources justNonNumbers() {
        if (this.isUnspecified()) {
            return NodeResources.unspecified();
        }
        return this.withVcpu(0.0).withMemoryGb(0.0).withDiskGb(0.0).withBandwidthGbps(0.0).with(GpuResources.getDefault());
    }

    public NodeResources subtract(NodeResources other) {
        this.ensureSpecified();
        other.ensureSpecified();
        if (!this.isInterchangeableWith(other)) {
            throw new IllegalArgumentException(this + " and " + other + " are not interchangeable");
        }
        return new NodeResources(this.vcpu - other.vcpu, this.memoryGb - other.memoryGb, this.diskGb - other.diskGb, this.bandwidthGbps - other.bandwidthGbps, this.diskSpeed.combineWith(other.diskSpeed), this.storageType.combineWith(other.storageType), this.architecture.combineWith(other.architecture), this.gpuResources.minus(other.gpuResources));
    }

    public NodeResources add(NodeResources other) {
        this.ensureSpecified();
        if (!this.isInterchangeableWith(other)) {
            throw new IllegalArgumentException(this + " and " + other + " are not interchangeable");
        }
        return new NodeResources(this.vcpu + other.vcpu, this.memoryGb + other.memoryGb, this.diskGb + other.diskGb, this.bandwidthGbps + other.bandwidthGbps, this.diskSpeed.combineWith(other.diskSpeed), this.storageType.combineWith(other.storageType), this.architecture.combineWith(other.architecture), this.gpuResources.plus(other.gpuResources));
    }

    private boolean isInterchangeableWith(NodeResources other) {
        this.ensureSpecified();
        other.ensureSpecified();
        if (this.diskSpeed != DiskSpeed.any && other.diskSpeed != DiskSpeed.any && this.diskSpeed != other.diskSpeed) {
            return false;
        }
        if (this.storageType != StorageType.any && other.storageType != StorageType.any && this.storageType != other.storageType) {
            return false;
        }
        return this.architecture == Architecture.any || other.architecture == Architecture.any || this.architecture == other.architecture;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeResources)) {
            return false;
        }
        NodeResources other = (NodeResources)o;
        if (!NodeResources.equal(this.vcpu, other.vcpu)) {
            return false;
        }
        if (!NodeResources.equal(this.memoryGb, other.memoryGb)) {
            return false;
        }
        if (!NodeResources.equal(this.diskGb, other.diskGb)) {
            return false;
        }
        if (!NodeResources.equal(this.bandwidthGbps, other.bandwidthGbps)) {
            return false;
        }
        if (!this.gpuResources.equals(other.gpuResources)) {
            return false;
        }
        if (this.diskSpeed != other.diskSpeed) {
            return false;
        }
        if (this.storageType != other.storageType) {
            return false;
        }
        return this.architecture == other.architecture;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, this.architecture});
    }

    private static StringBuilder appendDouble(StringBuilder sb, double d) {
        long x10 = Math.round(d * 10.0);
        sb.append(x10 / 10L).append('.').append(x10 % 10L);
        return sb;
    }

    public String toString() {
        if (this.isUnspecified()) {
            return "unspecified resources";
        }
        StringBuilder sb = new StringBuilder("[vcpu: ");
        NodeResources.appendDouble(sb, this.vcpu);
        sb.append(", memory: ");
        NodeResources.appendDouble(sb, this.memoryGb);
        sb.append(" Gb, disk ");
        NodeResources.appendDouble(sb, this.diskGb);
        sb.append(" Gb");
        if (this.bandwidthGbps > 0.0) {
            sb.append(", bandwidth: ");
            NodeResources.appendDouble(sb, this.bandwidthGbps);
            sb.append(" Gbps");
        }
        if (!this.diskSpeed.isDefault()) {
            sb.append(", disk speed: ").append((Object)this.diskSpeed);
        }
        if (!this.storageType.isDefault()) {
            sb.append(", storage type: ").append((Object)this.storageType);
        }
        sb.append(", architecture: ").append((Object)this.architecture);
        if (!this.gpuResources.isDefault()) {
            sb.append(", gpu count: ").append(this.gpuResources.count());
            sb.append(", gpu memory: ");
            NodeResources.appendDouble(sb, this.memoryGb);
            sb.append(" Gb");
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean satisfies(NodeResources other) {
        this.ensureSpecified();
        other.ensureSpecified();
        if (this.vcpu < other.vcpu) {
            return false;
        }
        if (this.memoryGb < other.memoryGb) {
            return false;
        }
        if (this.diskGb < other.diskGb) {
            return false;
        }
        if (this.bandwidthGbps < other.bandwidthGbps) {
            return false;
        }
        if (this.gpuResources.lessThan(other.gpuResources)) {
            return false;
        }
        if (other.diskSpeed != DiskSpeed.any && other.diskSpeed != this.diskSpeed) {
            return false;
        }
        if (other.storageType != StorageType.any && other.storageType != this.storageType) {
            return false;
        }
        return other.architecture == Architecture.any || other.architecture == this.architecture;
    }

    public boolean compatibleWith(NodeResources requested) {
        if (!NodeResources.equal(this.vcpu, requested.vcpu)) {
            return false;
        }
        if (!NodeResources.equal(this.memoryGb, requested.memoryGb)) {
            return false;
        }
        if (this.storageType == StorageType.local || requested.storageType == StorageType.local ? !NodeResources.equal(this.diskGb, requested.diskGb) : this.diskGb < requested.diskGb) {
            return false;
        }
        if (!this.gpuResources.equals(requested.gpuResources)) {
            return false;
        }
        if (!this.diskSpeed.compatibleWith(requested.diskSpeed)) {
            return false;
        }
        if (!this.storageType.compatibleWith(requested.storageType)) {
            return false;
        }
        return this.architecture.compatibleWith(requested.architecture);
    }

    public boolean equalsWhereSpecified(NodeResources other) {
        if (!NodeResources.equal(this.vcpu, other.vcpu)) {
            return false;
        }
        if (!NodeResources.equal(this.memoryGb, other.memoryGb)) {
            return false;
        }
        if (!NodeResources.equal(this.diskGb, other.diskGb)) {
            return false;
        }
        if (!NodeResources.equal(this.bandwidthGbps, other.bandwidthGbps)) {
            return false;
        }
        if (!this.gpuResources.equals(other.gpuResources)) {
            return false;
        }
        if (!this.diskSpeed.compatibleWith(other.diskSpeed)) {
            return false;
        }
        if (!this.storageType.compatibleWith(other.storageType)) {
            return false;
        }
        return this.architecture.compatibleWith(other.architecture);
    }

    public static NodeResources unspecified() {
        return unspecified;
    }

    public boolean isUnspecified() {
        return this == unspecified;
    }

    private void ensureSpecified() {
        if (this.isUnspecified()) {
            throw new IllegalStateException("Cannot perform this on unspecified resources");
        }
    }

    public double distanceTo(NodeResources other) {
        if (!this.diskSpeed().compatibleWith(other.diskSpeed())) {
            return Double.MAX_VALUE;
        }
        if (!this.storageType().compatibleWith(other.storageType())) {
            return Double.MAX_VALUE;
        }
        double distance = Math.pow(this.vcpu() - other.vcpu(), 2.0) + Math.pow(this.memoryGb() - other.memoryGb(), 2.0);
        if (this.storageType() == StorageType.local || other.storageType() == StorageType.local) {
            distance += Math.pow(this.diskGb() - other.diskGb(), 2.0);
        }
        return distance;
    }

    public Optional<NodeResources> asOptional() {
        return this.isUnspecified() ? Optional.empty() : Optional.of(this);
    }

    private static boolean equal(double a, double b) {
        return Math.abs(a - b) < 1.0E-8;
    }

    public static NodeResources fromLegacyName(String name) {
        if (!name.startsWith("d-")) {
            throw new IllegalArgumentException("A node specification string must start by 'd-' but was '" + name + "'");
        }
        String[] parts = name.split("-");
        if (parts.length != 4) {
            throw new IllegalArgumentException("A node specification string must contain three numbers separated by '-' but was '" + name + "'");
        }
        double cpu = Integer.parseInt(parts[1]);
        double mem = Integer.parseInt(parts[2]);
        double dsk = Integer.parseInt(parts[3]);
        if (cpu == 0.0) {
            cpu = 0.5;
        }
        if (cpu == 2.0 && mem == 8.0) {
            cpu = 1.5;
        }
        if (cpu == 2.0 && mem == 12.0) {
            cpu = 2.3;
        }
        return new NodeResources(cpu, mem, dsk, 0.3, DiskSpeed.getDefault(), StorageType.getDefault(), Architecture.x86_64);
    }

    private static double validate(double value, String valueName) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException(valueName + " cannot be NaN");
        }
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException(valueName + " cannot be infinite");
        }
        return value;
    }

    public static NodeResources zero() {
        return zero;
    }

    public static enum DiskSpeed {
        fast,
        slow,
        any;


        public static int compare(DiskSpeed a, DiskSpeed b) {
            if (a == any) {
                a = slow;
            }
            if (b == any) {
                b = slow;
            }
            if (a == slow && b == fast) {
                return -1;
            }
            if (a == fast && b == slow) {
                return 1;
            }
            return 0;
        }

        public boolean compatibleWith(DiskSpeed other) {
            return this == any || other == any || other == this;
        }

        private DiskSpeed combineWith(DiskSpeed other) {
            if (this == any) {
                return other;
            }
            if (other == any) {
                return this;
            }
            if (this == other) {
                return this;
            }
            throw new IllegalArgumentException(this + " cannot be combined with " + other);
        }

        public boolean isDefault() {
            return this == DiskSpeed.getDefault();
        }

        public static DiskSpeed getDefault() {
            return fast;
        }
    }

    public static enum StorageType {
        remote,
        local,
        any;


        public static int compare(StorageType a, StorageType b) {
            if (a == any) {
                a = remote;
            }
            if (b == any) {
                b = remote;
            }
            if (a == remote && b == local) {
                return -1;
            }
            if (a == local && b == remote) {
                return 1;
            }
            return 0;
        }

        public boolean compatibleWith(StorageType other) {
            return this == any || other == any || other == this;
        }

        private StorageType combineWith(StorageType other) {
            if (this == any) {
                return other;
            }
            if (other == any) {
                return this;
            }
            if (this == other) {
                return this;
            }
            throw new IllegalArgumentException(this + " cannot be combined with " + other);
        }

        public boolean isDefault() {
            return this == StorageType.getDefault();
        }

        public static StorageType getDefault() {
            return any;
        }
    }

    public static enum Architecture {
        x86_64,
        arm64,
        any;


        public static int compare(Architecture a, Architecture b) {
            if (a == any) {
                a = x86_64;
            }
            if (b == any) {
                b = x86_64;
            }
            if (a == x86_64 && b == arm64) {
                return -1;
            }
            if (a == arm64 && b == x86_64) {
                return 1;
            }
            return 0;
        }

        public boolean compatibleWith(Architecture other) {
            return this == any || other == any || other == this;
        }

        private Architecture combineWith(Architecture other) {
            if (this == any) {
                return other;
            }
            if (other == any) {
                return this;
            }
            if (this == other) {
                return this;
            }
            throw new IllegalArgumentException(this + " cannot be combined with " + other);
        }

        public boolean isDefault() {
            return this == Architecture.getDefault();
        }

        public static Architecture getDefault() {
            return x86_64;
        }
    }

    public record GpuResources(int count, double memoryGb) {
        private static final GpuResources none = new GpuResources(0, 0.0);

        public GpuResources {
            if (count < 0) {
                throw new IllegalArgumentException("GPU count cannot be negative, got " + count);
            }
            if (memoryGb < 0.0) {
                throw new IllegalArgumentException("GPU memory cannot be negative, got " + memoryGb);
            }
            NodeResources.validate(memoryGb, "memory");
        }

        private double totalMemory() {
            return (double)this.count * this.memoryGb;
        }

        private boolean lessThan(GpuResources other) {
            return this.totalMemory() < other.totalMemory();
        }

        public boolean isDefault() {
            return this.equals(GpuResources.getDefault());
        }

        public static GpuResources getDefault() {
            return none;
        }

        public GpuResources plus(GpuResources other) {
            return new GpuResources(this.count + other.count, this.memoryGb + other.memoryGb);
        }

        public GpuResources minus(GpuResources other) {
            return new GpuResources(this.count - other.count, this.memoryGb - other.memoryGb);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GpuResources that = (GpuResources)o;
            return this.count == that.count && NodeResources.equal(this.memoryGb, that.memoryGb);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.count, this.memoryGb);
        }
    }
}

