/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterResources;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.NodeType;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public final class Capacity {
    private final ClusterResources min;
    private final ClusterResources max;
    private final boolean required;
    private final boolean canFail;
    private final NodeType type;
    private final Optional<CloudAccount> cloudAccount;

    private Capacity(ClusterResources min, ClusterResources max, boolean required, boolean canFail, NodeType type, Optional<CloudAccount> cloudAccount) {
        Capacity.validate(min);
        Capacity.validate(max);
        if (max.smallerThan(min)) {
            throw new IllegalArgumentException("The max capacity must be larger than the min capacity, but got min " + min + " and max " + max);
        }
        if (!min.equals(max) && Stream.of(min, max).anyMatch(cr -> !cr.nodeResources().gpuResources().isDefault())) {
            throw new IllegalArgumentException("Capacity range does not allow GPU, got min " + min + " and max " + max);
        }
        this.min = min;
        this.max = max;
        this.required = required;
        this.canFail = canFail;
        this.type = type;
        this.cloudAccount = Objects.requireNonNull(cloudAccount);
    }

    private static void validate(ClusterResources resources) {
        if (resources.nodes() == 0 && resources.groups() == 0) {
            return;
        }
        if (resources.nodes() % resources.groups() != 0) {
            throw new IllegalArgumentException("The number of nodes (" + resources.nodes() + ") must be divisible by the number of groups (" + resources.groups() + ")");
        }
    }

    public ClusterResources minResources() {
        return this.min;
    }

    public ClusterResources maxResources() {
        return this.max;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean canFail() {
        return this.canFail;
    }

    public NodeType type() {
        return this.type;
    }

    public Optional<CloudAccount> cloudAccount() {
        return this.cloudAccount;
    }

    public Capacity withLimits(ClusterResources min, ClusterResources max) {
        return new Capacity(min, max, this.required, this.canFail, this.type, this.cloudAccount);
    }

    public String toString() {
        return (this.required ? "required " : "") + (this.min.equals(this.max) ? this.min : "between " + this.min + " and " + this.max);
    }

    public static Capacity from(ClusterResources resources) {
        return Capacity.from(resources, resources);
    }

    public static Capacity from(ClusterResources min, ClusterResources max) {
        return Capacity.from(min, max, false, true);
    }

    public static Capacity from(ClusterResources resources, boolean required, boolean canFail) {
        return Capacity.from(resources, required, canFail, NodeType.tenant);
    }

    public static Capacity from(ClusterResources min, ClusterResources max, boolean required, boolean canFail) {
        return Capacity.from(min, max, required, canFail, Optional.empty());
    }

    public static Capacity from(ClusterResources min, ClusterResources max, boolean required, boolean canFail, Optional<CloudAccount> cloudAccount) {
        return new Capacity(min, max, required, canFail, NodeType.tenant, cloudAccount);
    }

    public static Capacity fromRequiredNodeType(NodeType type) {
        return Capacity.from(new ClusterResources(0, 0, NodeResources.unspecified()), true, false, type);
    }

    private static Capacity from(ClusterResources resources, boolean required, boolean canFail, NodeType type) {
        return new Capacity(resources, resources, required, canFail, type, Optional.empty());
    }
}

