/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.CloudName;
import java.util.Objects;

public class Cloud {
    private final CloudName name;
    private final boolean dynamicProvisioning;
    private final boolean requireAccessControl;
    private final CloudAccount account;

    private Cloud(CloudName name, boolean dynamicProvisioning, boolean requireAccessControl, CloudAccount account) {
        this.name = Objects.requireNonNull(name);
        this.dynamicProvisioning = dynamicProvisioning;
        this.requireAccessControl = requireAccessControl;
        this.account = Objects.requireNonNull(account);
        if (name.equals((Object)CloudName.AWS) && account.isEmpty()) {
            throw new IllegalArgumentException("Account must be non-empty in cloud '" + name + "'");
        }
    }

    public CloudName name() {
        return this.name;
    }

    public boolean dynamicProvisioning() {
        return this.dynamicProvisioning;
    }

    public boolean requireAccessControl() {
        return this.requireAccessControl;
    }

    public CloudAccount account() {
        return this.account;
    }

    public static Cloud defaultCloud() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "cloud " + this.name;
    }

    public static class Builder {
        private CloudName name = CloudName.DEFAULT;
        private boolean dynamicProvisioning = false;
        private boolean requireAccessControl = false;
        private CloudAccount account = CloudAccount.empty;

        public Builder name(CloudName name) {
            this.name = name;
            return this;
        }

        public Builder dynamicProvisioning(boolean dynamicProvisioning) {
            this.dynamicProvisioning = dynamicProvisioning;
            return this;
        }

        public Builder requireAccessControl(boolean requireAccessControl) {
            this.requireAccessControl = requireAccessControl;
            return this;
        }

        public Builder account(CloudAccount account) {
            this.account = account;
            return this;
        }

        public Cloud build() {
            return new Cloud(this.name, this.dynamicProvisioning, this.requireAccessControl, this.account);
        }
    }
}

