/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.NetworkPorts;
import com.yahoo.config.provision.NodeResources;
import java.util.Objects;
import java.util.Optional;

public class HostSpec
implements Comparable<HostSpec> {
    private final String hostname;
    private final NodeResources realResources;
    private final NodeResources advertisedResources;
    private final NodeResources requestedResources;
    private final Optional<ClusterMembership> membership;
    private final Optional<Version> version;
    private final Optional<DockerImage> dockerImageRepo;
    private final Optional<NetworkPorts> networkPorts;

    public HostSpec(String hostname, Optional<NetworkPorts> networkPorts) {
        this(hostname, NodeResources.unspecified(), NodeResources.unspecified(), NodeResources.unspecified(), Optional.empty(), Optional.empty(), networkPorts, Optional.empty());
    }

    public HostSpec(String hostname, NodeResources realResources, NodeResources advertisedResources, NodeResources requestedResources, ClusterMembership membership, Optional<Version> version, Optional<NetworkPorts> networkPorts, Optional<DockerImage> dockerImageRepo) {
        this(hostname, realResources, advertisedResources, requestedResources, Optional.of(membership), version, networkPorts, dockerImageRepo);
    }

    private HostSpec(String hostname, NodeResources realResources, NodeResources advertisedResurces, NodeResources requestedResources, Optional<ClusterMembership> membership, Optional<Version> version, Optional<NetworkPorts> networkPorts, Optional<DockerImage> dockerImageRepo) {
        if (hostname == null || hostname.isEmpty()) {
            throw new IllegalArgumentException("Hostname must be specified");
        }
        this.hostname = hostname;
        this.realResources = Objects.requireNonNull(realResources);
        this.advertisedResources = Objects.requireNonNull(advertisedResurces);
        this.requestedResources = Objects.requireNonNull(requestedResources, "RequestedResources cannot be null");
        this.membership = Objects.requireNonNull(membership);
        this.version = Objects.requireNonNull(version, "Version cannot be null but can be empty");
        this.networkPorts = Objects.requireNonNull(networkPorts, "Network ports cannot be null but can be empty");
        this.dockerImageRepo = Objects.requireNonNull(dockerImageRepo, "Docker image repo cannot be null but can be empty");
    }

    public String hostname() {
        return this.hostname;
    }

    public NodeResources realResources() {
        return this.realResources;
    }

    public NodeResources advertisedResources() {
        return this.advertisedResources;
    }

    public Optional<Version> version() {
        return this.version;
    }

    public Optional<ClusterMembership> membership() {
        return this.membership;
    }

    public Optional<NetworkPorts> networkPorts() {
        return this.networkPorts;
    }

    public Optional<NodeResources> requestedResources() {
        return this.requestedResources.asOptional();
    }

    public Optional<DockerImage> dockerImageRepo() {
        return this.dockerImageRepo;
    }

    public HostSpec withPorts(Optional<NetworkPorts> ports) {
        return new HostSpec(this.hostname, this.realResources, this.advertisedResources, this.requestedResources, this.membership, this.version, ports, this.dockerImageRepo);
    }

    public String toString() {
        return this.hostname + (String)(this.membership.isPresent() ? " (membership: " + this.membership.get() + ")" : " (no membership)");
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof HostSpec)) {
            return false;
        }
        return ((HostSpec)other).hostname.equals(this.hostname);
    }

    public int hashCode() {
        return this.hostname.hashCode();
    }

    @Override
    public int compareTo(HostSpec other) {
        return this.hostname.compareTo(other.hostname);
    }
}

