/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.serialization;

import com.yahoo.component.Version;
import com.yahoo.config.provision.AllocatedHosts;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.serialization.NetworkPortsSerializer;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.slime.SlimeUtils;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Optional;

public class AllocatedHostsSerializer {
    private static final String mappingKey = "mapping";
    private static final String hostSpecKey = "hostSpec";
    private static final String hostSpecHostNameKey = "hostName";
    private static final String hostSpecMembershipKey = "membership";
    private static final String realResourcesKey = "realResources";
    private static final String advertisedResourcesKey = "advertisedResources";
    private static final String requestedResourcesKey = "requestedResources";
    private static final String vcpuKey = "vcpu";
    private static final String memoryKey = "memory";
    private static final String diskKey = "disk";
    private static final String bandwidthKey = "bandwidth";
    private static final String diskSpeedKey = "diskSpeed";
    private static final String storageTypeKey = "storageType";
    private static final String architectureKey = "architecture";
    private static final String hostSpecVespaVersionKey = "vespaVersion";
    private static final String hostSpecDockerImageRepoKey = "dockerImageRepo";
    private static final String hostSpecCurrentVespaVersionKey = "currentVespaVersion";
    private static final String hostSpecNetworkPortsKey = "ports";

    public static byte[] toJson(AllocatedHosts allocatedHosts) throws IOException {
        Slime slime = new Slime();
        AllocatedHostsSerializer.toSlime(allocatedHosts, slime.setObject());
        return SlimeUtils.toJsonBytes((Slime)slime);
    }

    public static void toSlime(AllocatedHosts allocatedHosts, Cursor cursor) {
        Cursor array = cursor.setArray(mappingKey);
        for (HostSpec host : allocatedHosts.getHosts()) {
            AllocatedHostsSerializer.toSlime(host, array.addObject().setObject(hostSpecKey));
        }
    }

    private static void toSlime(HostSpec host, Cursor object) {
        object.setString(hostSpecHostNameKey, host.hostname());
        host.membership().ifPresent(membership -> {
            object.setString(hostSpecMembershipKey, membership.stringValue());
            object.setString(hostSpecVespaVersionKey, membership.cluster().vespaVersion().toFullString());
            membership.cluster().dockerImageRepo().ifPresent(repo -> object.setString(hostSpecDockerImageRepoKey, repo.untagged()));
        });
        AllocatedHostsSerializer.toSlime(host.realResources(), object.setObject(realResourcesKey));
        AllocatedHostsSerializer.toSlime(host.advertisedResources(), object.setObject(advertisedResourcesKey));
        host.requestedResources().ifPresent(resources -> AllocatedHostsSerializer.toSlime(resources, object.setObject(requestedResourcesKey)));
        host.version().ifPresent(version -> object.setString(hostSpecCurrentVespaVersionKey, version.toFullString()));
        host.networkPorts().ifPresent(ports -> NetworkPortsSerializer.toSlime(ports, object.setArray(hostSpecNetworkPortsKey)));
    }

    private static void toSlime(NodeResources resources, Cursor resourcesObject) {
        resourcesObject.setDouble(vcpuKey, resources.vcpu());
        resourcesObject.setDouble(memoryKey, resources.memoryGb());
        resourcesObject.setDouble(diskKey, resources.diskGb());
        resourcesObject.setDouble(bandwidthKey, resources.bandwidthGbps());
        resourcesObject.setString(diskSpeedKey, AllocatedHostsSerializer.diskSpeedToString(resources.diskSpeed()));
        resourcesObject.setString(storageTypeKey, AllocatedHostsSerializer.storageTypeToString(resources.storageType()));
        resourcesObject.setString(architectureKey, AllocatedHostsSerializer.architectureToString(resources.architecture()));
    }

    public static AllocatedHosts fromJson(byte[] json) {
        return AllocatedHostsSerializer.fromSlime((Inspector)SlimeUtils.jsonToSlime((byte[])json).get());
    }

    public static AllocatedHosts fromSlime(Inspector inspector) {
        Inspector array = inspector.field(mappingKey);
        LinkedHashSet<HostSpec> hosts = new LinkedHashSet<HostSpec>();
        array.traverse((i, host) -> hosts.add(AllocatedHostsSerializer.hostFromSlime(host.field(hostSpecKey))));
        return AllocatedHosts.withHosts(hosts);
    }

    private static HostSpec hostFromSlime(Inspector object) {
        if (object.field(hostSpecMembershipKey).valid()) {
            return new HostSpec(object.field(hostSpecHostNameKey).asString(), AllocatedHostsSerializer.nodeResourcesFromSlime(object.field(realResourcesKey)), AllocatedHostsSerializer.nodeResourcesFromSlime(object.field(advertisedResourcesKey)), AllocatedHostsSerializer.optionalNodeResourcesFromSlime(object.field(requestedResourcesKey)), AllocatedHostsSerializer.membershipFromSlime(object), AllocatedHostsSerializer.optionalString(object.field(hostSpecCurrentVespaVersionKey)).map(Version::new), NetworkPortsSerializer.fromSlime(object.field(hostSpecNetworkPortsKey)), AllocatedHostsSerializer.optionalDockerImage(object.field(hostSpecDockerImageRepoKey)));
        }
        return new HostSpec(object.field(hostSpecHostNameKey).asString(), NetworkPortsSerializer.fromSlime(object.field(hostSpecNetworkPortsKey)));
    }

    private static NodeResources nodeResourcesFromSlime(Inspector resources) {
        return new NodeResources(resources.field(vcpuKey).asDouble(), resources.field(memoryKey).asDouble(), resources.field(diskKey).asDouble(), resources.field(bandwidthKey).asDouble(), AllocatedHostsSerializer.diskSpeedFromSlime(resources.field(diskSpeedKey)), AllocatedHostsSerializer.storageTypeFromSlime(resources.field(storageTypeKey)), AllocatedHostsSerializer.architectureFromSlime(resources.field(architectureKey)));
    }

    private static NodeResources optionalNodeResourcesFromSlime(Inspector resources) {
        if (!resources.valid()) {
            return NodeResources.unspecified();
        }
        return AllocatedHostsSerializer.nodeResourcesFromSlime(resources);
    }

    private static NodeResources.DiskSpeed diskSpeedFromSlime(Inspector diskSpeed) {
        switch (diskSpeed.asString()) {
            case "fast": {
                return NodeResources.DiskSpeed.fast;
            }
            case "slow": {
                return NodeResources.DiskSpeed.slow;
            }
            case "any": {
                return NodeResources.DiskSpeed.any;
            }
        }
        throw new IllegalStateException("Illegal disk-speed value '" + diskSpeed.asString() + "'");
    }

    private static String diskSpeedToString(NodeResources.DiskSpeed diskSpeed) {
        switch (diskSpeed) {
            case fast: {
                return "fast";
            }
            case slow: {
                return "slow";
            }
            case any: {
                return "any";
            }
        }
        throw new IllegalStateException("Illegal disk-speed value '" + diskSpeed + "'");
    }

    private static NodeResources.StorageType storageTypeFromSlime(Inspector storageType) {
        switch (storageType.asString()) {
            case "remote": {
                return NodeResources.StorageType.remote;
            }
            case "local": {
                return NodeResources.StorageType.local;
            }
            case "any": {
                return NodeResources.StorageType.any;
            }
        }
        throw new IllegalStateException("Illegal storage-type value '" + storageType.asString() + "'");
    }

    private static String storageTypeToString(NodeResources.StorageType storageType) {
        switch (storageType) {
            case remote: {
                return "remote";
            }
            case local: {
                return "local";
            }
            case any: {
                return "any";
            }
        }
        throw new IllegalStateException("Illegal storage-type value '" + storageType + "'");
    }

    private static NodeResources.Architecture architectureFromSlime(Inspector architecture) {
        if (!architecture.valid()) {
            return NodeResources.Architecture.x86_64;
        }
        switch (architecture.asString()) {
            case "x86_64": {
                return NodeResources.Architecture.x86_64;
            }
            case "arm64": {
                return NodeResources.Architecture.arm64;
            }
            case "any": {
                return NodeResources.Architecture.any;
            }
        }
        throw new IllegalStateException("Illegal architecture value '" + architecture.asString() + "'");
    }

    private static String architectureToString(NodeResources.Architecture architecture) {
        switch (architecture) {
            case x86_64: {
                return "x86_64";
            }
            case arm64: {
                return "arm64";
            }
            case any: {
                return "any";
            }
        }
        throw new IllegalStateException("Illegal architecture value '" + architecture + "'");
    }

    private static ClusterMembership membershipFromSlime(Inspector object) {
        return ClusterMembership.from(object.field(hostSpecMembershipKey).asString(), Version.fromString((String)object.field(hostSpecVespaVersionKey).asString()), object.field(hostSpecDockerImageRepoKey).valid() ? Optional.of(DockerImage.fromString(object.field(hostSpecDockerImageRepoKey).asString())) : Optional.empty());
    }

    private static Optional<String> optionalString(Inspector inspector) {
        if (!inspector.valid()) {
            return Optional.empty();
        }
        return Optional.of(inspector.asString());
    }

    private static Optional<DockerImage> optionalDockerImage(Inspector inspector) {
        if (!inspector.valid()) {
            return Optional.empty();
        }
        return Optional.of(DockerImage.fromString(inspector.asString()));
    }
}

