/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import java.util.Objects;
import java.util.Optional;

public class DockerImage {
    public static final DockerImage EMPTY = new DockerImage("", "", Optional.empty());
    private final String registry;
    private final String repository;
    private final Optional<String> tag;

    DockerImage(String registry, String repository, Optional<String> tag) {
        this.registry = Objects.requireNonNull(registry, "registry must be non-null");
        this.repository = Objects.requireNonNull(repository, "repository must be non-null");
        this.tag = Objects.requireNonNull(tag, "tag must be non-null");
        if (tag.isPresent() && tag.get().isBlank()) {
            throw new IllegalArgumentException("Set tag cannot be empty");
        }
    }

    public String registry() {
        return this.registry;
    }

    public String repository() {
        return this.repository;
    }

    public String untagged() {
        return new DockerImage(this.registry, this.repository, Optional.empty()).asString();
    }

    public Optional<String> tag() {
        return this.tag;
    }

    public Version tagAsVersion() {
        return this.tag.map(Version::new).orElse(Version.emptyVersion);
    }

    public DockerImage withTag(Version version) {
        return new DockerImage(this.registry, this.repository, Optional.of(version.toFullString()));
    }

    public DockerImage withRegistry(String registry) {
        if (registry.isBlank()) {
            throw new IllegalArgumentException("Registry cannot be empty");
        }
        if (registry.charAt(registry.length() - 1) == '/') {
            throw new IllegalArgumentException("Registry cannot end with '/': " + registry);
        }
        return new DockerImage(registry, this.repository, this.tag);
    }

    public String asString() {
        if (this.equals(EMPTY)) {
            return "";
        }
        return this.registry + "/" + this.repository + this.tag.map(t -> ":" + t).orElse("");
    }

    public String toString() {
        return this.asString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerImage that = (DockerImage)o;
        return this.registry.equals(that.registry) && this.repository.equals(that.repository) && this.tag.equals(that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.registry, this.repository, this.tag);
    }

    public static DockerImage fromString(String s) {
        Optional<String> tag;
        if (s.isEmpty()) {
            return EMPTY;
        }
        int repositoryStart = s.lastIndexOf(47, s.lastIndexOf(47) - 1);
        if (repositoryStart < 0) {
            throw new IllegalArgumentException("Expected to find at least 2 path segments in: " + s);
        }
        String registry = s.substring(0, repositoryStart);
        String repository = s.substring(repositoryStart + 1);
        int tagStart = repository.indexOf(58);
        Optional<String> optional = tag = tagStart < 0 ? Optional.empty() : Optional.of(repository.substring(tagStart + 1));
        if (tagStart >= 0) {
            repository = repository.substring(0, tagStart);
        }
        if (repository.isEmpty()) {
            throw new IllegalArgumentException("Repository must be non-empty in '" + s + "'");
        }
        return new DockerImage(registry, repository, tag);
    }
}

