/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SystemName {
    cd(false, true),
    main(false, false),
    Public(true, false),
    PublicCd(true, true),
    dev(false, false);

    private final boolean isPublic;
    private final boolean isCd;

    private SystemName(boolean isPublic, boolean isCd) {
        this.isPublic = isPublic;
        this.isCd = isCd;
    }

    public static SystemName defaultSystem() {
        return main;
    }

    public static SystemName from(String value) {
        return switch (value.toLowerCase()) {
            case "dev" -> dev;
            case "cd" -> cd;
            case "main" -> main;
            case "public" -> Public;
            case "publiccd" -> PublicCd;
            default -> throw new IllegalArgumentException(String.format("'%s' is not a valid system", value));
        };
    }

    public String value() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case dev -> "dev";
            case cd -> "cd";
            case main -> "main";
            case Public -> "public";
            case PublicCd -> "publiccd";
        };
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isCd() {
        return this.isCd;
    }

    public static Set<SystemName> all() {
        return EnumSet.allOf(SystemName.class);
    }

    public static Set<SystemName> allOf(Predicate<SystemName> predicate) {
        return Stream.of(SystemName.values()).filter(predicate).collect(Collectors.toUnmodifiableSet());
    }

    public static Set<SystemName> hostedVespa() {
        return EnumSet.of(main, cd, Public, PublicCd);
    }
}

