/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.serialization;

import com.yahoo.config.provision.NetworkPorts;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import java.util.ArrayList;
import java.util.Optional;

public class NetworkPortsSerializer {
    private static final String portNumberKey = "port";
    private static final String serviceTypeKey = "type";
    private static final String configIdKey = "cfg";
    private static final String portSuffixKey = "suf";

    public static void toSlime(NetworkPorts networkPorts, Cursor array) {
        for (NetworkPorts.Allocation allocation : networkPorts.allocations()) {
            Cursor object = array.addObject();
            object.setLong(portNumberKey, (long)allocation.port);
            object.setString(serviceTypeKey, allocation.serviceType);
            object.setString(configIdKey, allocation.configId);
            object.setString(portSuffixKey, allocation.portSuffix);
        }
    }

    public static Optional<NetworkPorts> fromSlime(Inspector array) {
        ArrayList<NetworkPorts.Allocation> list = new ArrayList<NetworkPorts.Allocation>(array.entries());
        array.traverse((i, item) -> list.add(new NetworkPorts.Allocation((int)item.field(portNumberKey).asLong(), item.field(serviceTypeKey).asString(), item.field(configIdKey).asString(), item.field(portSuffixKey).asString())));
        if (list.size() > 0) {
            NetworkPorts allocator = new NetworkPorts(list);
            return Optional.of(allocator);
        }
        return Optional.empty();
    }
}

