/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.Optional;

public enum NodeType {
    tenant("Tenant node"),
    host("Tenant host", tenant),
    proxy("Proxy node"),
    proxyhost("Proxy host", proxy),
    config("Config server node"),
    confighost("Config server host", config),
    controller("Controller node"),
    controllerhost("Controller host", controller);

    private final String description;
    private final Optional<NodeType> childNodeType;

    public static Optional<NodeType> ofOptional(String name) {
        for (NodeType type : NodeType.values()) {
            if (!type.name().equals(name)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    private NodeType(String description) {
        this(description, null);
    }

    private NodeType(String description, NodeType childNodeTypes) {
        this.childNodeType = Optional.ofNullable(childNodeTypes);
        this.description = description;
    }

    public boolean isHost() {
        return this.childNodeType.isPresent();
    }

    public boolean isConfigServerLike() {
        return this == config || this == controller;
    }

    public boolean isConfigServerHostLike() {
        return this == confighost || this == controllerhost;
    }

    public boolean isSharable() {
        return this == host;
    }

    public String description() {
        return this.description;
    }

    public NodeType childNodeType() {
        return this.childNodeType.orElseThrow(() -> new IllegalStateException(this + " is not a host"));
    }

    public boolean canRun(NodeType type) {
        return this.childNodeType.map(t -> t == type).orElse(false);
    }

    public NodeType parentNodeType() {
        for (NodeType type : NodeType.values()) {
            if (!type.canRun(this)) continue;
            return type;
        }
        throw new IllegalStateException(this + " has no parent");
    }

    public NodeType hostType() {
        if (this.isHost()) {
            return this;
        }
        for (NodeType type : NodeType.values()) {
            if (!type.canRun(this)) continue;
            return type;
        }
        throw new IllegalStateException("No host of " + this + " exists");
    }
}

