/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import ai.vespa.http.DomainName;
import ai.vespa.http.HttpURL;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterSpec;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public interface EndpointsChecker {
    public static EndpointsChecker of(HealthChecker healthChecker) {
        return zoneEndpoints -> EndpointsChecker.endpointsAvailable(zoneEndpoints, EndpointsChecker::resolveAll, healthChecker);
    }

    public static EndpointsChecker mock(NameResolver resolver, HealthChecker healthChecker) {
        return zoneEndpoints -> EndpointsChecker.endpointsAvailable(zoneEndpoints, resolver, healthChecker);
    }

    public Availability endpointsAvailable(List<Endpoint> var1);

    private static Availability endpointsAvailable(List<Endpoint> zoneEndpoints, NameResolver nameResolver, HealthChecker healthChecker) {
        if (zoneEndpoints.isEmpty()) {
            return new Availability(Status.endpointsUnavailable, "Endpoints not yet ready.");
        }
        for (Endpoint endpoint : zoneEndpoints) {
            Set<String> resolvedIpAddresses = EndpointsChecker.resolveIpAddresses(endpoint.url().domain(), nameResolver);
            if (resolvedIpAddresses.isEmpty()) {
                return new Availability(Status.endpointsUnavailable, "DNS lookup yielded no IP address for '" + endpoint.url().domain() + "'.");
            }
            if (endpoint.ipAddress().isPresent()) {
                if (resolvedIpAddresses.contains(endpoint.ipAddress().get().getHostAddress())) continue;
                return new Availability(Status.endpointsUnavailable, "IP address(es) of '" + endpoint.url().domain() + "' (" + resolvedIpAddresses + ") do not include load balancer IP ' (" + endpoint.ipAddress().get().getHostAddress() + ")");
            }
            if (endpoint.canonicalName().isEmpty()) continue;
            List<String> cnameAnswers = nameResolver.resolve(NameType.CNAME, endpoint.url().domain());
            if (!cnameAnswers.contains(endpoint.canonicalName().get().value())) {
                return new Availability(Status.endpointsUnavailable, "CNAME '" + endpoint.url().domain() + "' points at " + cnameAnswers + " but should point at load balancer " + endpoint.canonicalName().map(name -> "'" + name + "'").orElse("nothing"));
            }
            Set<String> loadBalancerAddresses = EndpointsChecker.resolveIpAddresses(endpoint.canonicalName().get(), nameResolver);
            if (loadBalancerAddresses.equals(resolvedIpAddresses)) continue;
            return new Availability(Status.endpointsUnavailable, "IP address(es) of CNAME '" + endpoint.url().domain() + "' (" + resolvedIpAddresses + ") and load balancer '" + endpoint.canonicalName().get() + "' (" + loadBalancerAddresses + ") are not equal");
        }
        Availability availability = Availability.ready;
        for (Endpoint endpoint : zoneEndpoints) {
            Availability candidate = healthChecker.healthy(endpoint);
            if (candidate.status.compareTo(availability.status) >= 0) continue;
            availability = candidate;
        }
        return availability;
    }

    private static Set<String> resolveIpAddresses(DomainName name, NameResolver nameResolver) {
        HashSet<String> answers = new HashSet<String>();
        answers.addAll(nameResolver.resolve(NameType.A, name));
        answers.addAll(nameResolver.resolve(NameType.AAAA, name));
        return answers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> resolveAll(NameType type, DomainName name) {
        try (InitialDirContext ctx = new InitialDirContext();){
            String entryType = type.name();
            Attributes attributes = ctx.getAttributes("dns:/" + name, new String[]{entryType});
            Attribute attribute = attributes.get(entryType);
            if (attribute == null) {
                List<String> list = List.of();
                return list;
            }
            ArrayList results = new ArrayList();
            attribute.getAll().asIterator().forEachRemaining(value -> {
                String answer = Objects.toString(value);
                answer = answer.endsWith(".") ? answer.substring(0, answer.length() - 1) : answer;
                results.add(answer);
            });
            List<String> list = Collections.unmodifiableList(results);
            return list;
        }
        catch (NameNotFoundException ignored) {
            return List.of();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface HealthChecker {
        public Availability healthy(Endpoint var1);
    }

    public static interface NameResolver {
        public List<String> resolve(NameType var1, DomainName var2);
    }

    public record Availability(Status status, String message) {
        public static final Availability ready = new Availability(Status.available, "Endpoints are ready.");
    }

    public static enum Status {
        endpointsUnavailable,
        containersUnhealthy,
        available;

    }

    public record Endpoint(ApplicationId applicationId, ClusterSpec.Id clusterName, HttpURL url, Optional<InetAddress> ipAddress, Optional<DomainName> canonicalName, boolean isPublic, CloudAccount account) {
    }

    public static enum NameType {
        A,
        AAAA,
        CNAME;

    }

    public static interface HealthCheckerProvider {
        default public HealthChecker getHealthChecker() {
            return __ -> Availability.ready;
        }
    }
}

