/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.Arrays;

public enum Environment {
    prod,
    staging,
    test,
    dev,
    perf;


    public boolean isManuallyDeployed() {
        return this == dev || this == perf;
    }

    public boolean isTest() {
        return this == test || this == staging;
    }

    public boolean isProduction() {
        return this == prod;
    }

    @Deprecated
    public boolean isMultiRegion() {
        return true;
    }

    public static Environment defaultEnvironment() {
        return prod;
    }

    public boolean isAnyOf(Environment ... environments) {
        return Arrays.stream(environments).anyMatch(e -> e == this);
    }

    public static Environment from(String value) {
        return switch (value) {
            case "prod" -> prod;
            case "staging" -> staging;
            case "test" -> test;
            case "dev" -> dev;
            case "perf" -> perf;
            default -> throw new IllegalArgumentException("'" + value + "' is not a valid environment identifier");
        };
    }

    public String value() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case prod -> "prod";
            case staging -> "staging";
            case test -> "test";
            case dev -> "dev";
            case perf -> "perf";
        };
    }
}

