/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import ai.vespa.http.DomainName;
import ai.vespa.http.HttpURL;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.CloudAccount;
import com.yahoo.config.provision.ClusterSpec;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public interface EndpointsChecker {
    public static EndpointsChecker of(HealthChecker healthChecker) {
        return zoneEndpoints -> EndpointsChecker.endpointsAvailable(zoneEndpoints, EndpointsChecker::resolveHostName, EndpointsChecker::resolveCname, healthChecker);
    }

    public static EndpointsChecker mock(HostNameResolver hostNameResolver, CNameResolver cNameResolver, HealthChecker healthChecker) {
        return zoneEndpoints -> EndpointsChecker.endpointsAvailable(zoneEndpoints, hostNameResolver, cNameResolver, healthChecker);
    }

    public Availability endpointsAvailable(List<Endpoint> var1);

    private static Availability endpointsAvailable(List<Endpoint> zoneEndpoints, HostNameResolver hostNameResolver, CNameResolver cNameResolver, HealthChecker healthChecker) {
        if (zoneEndpoints.isEmpty()) {
            return new Availability(Status.endpointsUnavailable, "Endpoints not yet ready.");
        }
        for (Endpoint endpoint : zoneEndpoints) {
            Optional<InetAddress> resolvedIpAddress = hostNameResolver.resolve(endpoint.url().domain());
            if (resolvedIpAddress.isEmpty()) {
                return new Availability(Status.endpointsUnavailable, "DNS lookup yielded no IP address for '" + endpoint.url().domain() + "'.");
            }
            if (resolvedIpAddress.equals(endpoint.ipAddress())) continue;
            if (endpoint.ipAddress().isPresent()) {
                return new Availability(Status.endpointsUnavailable, "IP address of '" + endpoint.url().domain() + "' (" + resolvedIpAddress.get().getHostAddress() + ") and load balancer ' (" + endpoint.ipAddress().get().getHostAddress() + ") are not equal");
            }
            if (endpoint.canonicalName().isEmpty()) continue;
            Optional<DomainName> cNameValue = cNameResolver.resolve(endpoint.url().domain());
            if (cNameValue.filter(arg_0 -> ((DomainName)endpoint.canonicalName().get()).equals(arg_0)).isEmpty()) {
                return new Availability(Status.endpointsUnavailable, "CNAME '" + endpoint.url().domain() + "' points at " + cNameValue.map(name -> "'" + name + "'").orElse("nothing") + " but should point at load balancer " + endpoint.canonicalName().map(name -> "'" + name + "'").orElse("nothing"));
            }
            Optional<InetAddress> loadBalancerAddress = hostNameResolver.resolve(endpoint.canonicalName().get());
            if (loadBalancerAddress.equals(resolvedIpAddress)) continue;
            return new Availability(Status.endpointsUnavailable, "IP address of CNAME '" + endpoint.url().domain() + "' (" + resolvedIpAddress.get().getHostAddress() + ") and load balancer '" + endpoint.canonicalName().get() + "' (" + loadBalancerAddress.map(InetAddress::getHostAddress).orElse("empty") + ") are not equal");
        }
        Availability availability = Availability.ready;
        for (Endpoint endpoint : zoneEndpoints) {
            Availability candidate = healthChecker.healthy(endpoint);
            if (candidate.status.compareTo(availability.status) >= 0) continue;
            availability = candidate;
        }
        return availability;
    }

    private static Optional<InetAddress> resolveHostName(DomainName hostname) {
        try {
            return Optional.of(InetAddress.getByName(hostname.value()));
        }
        catch (UnknownHostException ignored) {
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<DomainName> resolveCname(DomainName endpoint) {
        try (InitialDirContext ctx = new InitialDirContext();){
            Attribute attribute;
            NamingEnumeration<?> vals;
            Attributes attrs = ctx.getAttributes("dns:/" + endpoint.value(), new String[]{"CNAME"});
            Iterator<? extends Attribute> iterator = Collections.list(attrs.getAll()).iterator();
            do {
                if (!iterator.hasNext()) return Optional.empty();
            } while (!(vals = (attribute = iterator.next()).getAll()).hasMoreElements());
            String hostname = vals.nextElement().toString();
            Optional<DomainName> optional = Optional.of(hostname.substring(0, hostname.length() - 1)).map(DomainName::of);
            return optional;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface HealthChecker {
        public Availability healthy(Endpoint var1);
    }

    public static interface HostNameResolver {
        public Optional<InetAddress> resolve(DomainName var1);
    }

    public static interface CNameResolver {
        public Optional<DomainName> resolve(DomainName var1);
    }

    public record Availability(Status status, String message) {
        public static final Availability ready = new Availability(Status.available, "Endpoints are ready.");
    }

    public static enum Status {
        endpointsUnavailable,
        containersUnhealthy,
        available;

    }

    public record Endpoint(ApplicationId applicationId, ClusterSpec.Id clusterName, HttpURL url, Optional<InetAddress> ipAddress, Optional<DomainName> canonicalName, boolean isPublic, CloudAccount account) {
    }

    public static interface HealthCheckerProvider {
        default public HealthChecker getHealthChecker() {
            return __ -> Availability.ready;
        }
    }
}

