/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.time.Duration;
import java.util.Objects;

public class ClusterInfo {
    private static final ClusterInfo empty = new Builder().build();
    private final Duration bcpDeadline;

    private ClusterInfo(Builder builder) {
        this.bcpDeadline = builder.bcpDeadline;
    }

    public Duration bcpDeadline() {
        return this.bcpDeadline;
    }

    public static ClusterInfo empty() {
        return empty;
    }

    public boolean isEmpty() {
        return this.equals(empty);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterInfo)) {
            return false;
        }
        ClusterInfo other = (ClusterInfo)o;
        return other.bcpDeadline.equals(this.bcpDeadline);
    }

    public int hashCode() {
        return Objects.hash(this.bcpDeadline);
    }

    public String toString() {
        return "cluster info: [bcp deadline: " + this.bcpDeadline + "]";
    }

    public static class Builder {
        private Duration bcpDeadline = Duration.ofMinutes(0L);

        public Builder bcpDeadline(Duration duration) {
            this.bcpDeadline = Objects.requireNonNull(duration);
            return this;
        }

        public ClusterInfo build() {
            return new ClusterInfo(this);
        }
    }
}

