/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.io.Serializable;
import java.util.Objects;
import java.util.OptionalInt;

public class IntRange {
    private static final IntRange empty = new IntRange(OptionalInt.empty(), OptionalInt.empty());
    private final OptionalInt from;
    private final OptionalInt to;

    public IntRange(OptionalInt from, OptionalInt to) {
        if (from.isPresent() && to.isPresent() && from.getAsInt() > to.getAsInt()) {
            throw new IllegalArgumentException("from " + from.getAsInt() + " is greater than to " + to.getAsInt());
        }
        this.from = from;
        this.to = to;
    }

    public OptionalInt from() {
        return this.from;
    }

    public OptionalInt to() {
        return this.to;
    }

    public boolean isEmpty() {
        return this.from.isEmpty() && this.to.isEmpty();
    }

    public boolean includes(int value) {
        if (this.from.isPresent() && value < this.from.getAsInt()) {
            return false;
        }
        return !this.to.isPresent() || value <= this.to.getAsInt();
    }

    public int fit(int value) {
        if (this.from.isPresent() && value < this.from.getAsInt()) {
            return this.from.getAsInt();
        }
        if (this.to.isPresent() && value > this.to.getAsInt()) {
            return this.to.getAsInt();
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntRange)) {
            return false;
        }
        IntRange other = (IntRange)o;
        if (!this.from.equals(other.from)) {
            return false;
        }
        return this.to.equals(other.to);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        if (this.from.equals(this.to)) {
            return String.valueOf(this.from.getAsInt());
        }
        return "[" + (Serializable)(this.from.isPresent() ? Integer.valueOf(this.from.getAsInt()) : "") + ", " + (Serializable)(this.to.isPresent() ? Integer.valueOf(this.to.getAsInt()) : "") + "]";
    }

    public static IntRange empty() {
        return empty;
    }

    public static IntRange from(int from) {
        return new IntRange(OptionalInt.of(from), OptionalInt.empty());
    }

    public static IntRange to(int to) {
        return new IntRange(OptionalInt.empty(), OptionalInt.of(to));
    }

    public static IntRange of(int fromTo) {
        return new IntRange(OptionalInt.of(fromTo), OptionalInt.of(fromTo));
    }

    public static IntRange of(int from, int to) {
        return new IntRange(OptionalInt.of(from), OptionalInt.of(to));
    }

    public IntRange fromAtMost(int minLimit) {
        if (this.from.isEmpty()) {
            return this;
        }
        if (this.from.getAsInt() <= minLimit) {
            return this;
        }
        return new IntRange(OptionalInt.of(minLimit), this.to);
    }

    public IntRange toAtLeast(int maxLimit) {
        if (this.to.isEmpty()) {
            return this;
        }
        if (this.to.getAsInt() >= maxLimit) {
            return this;
        }
        return new IntRange(this.from, OptionalInt.of(maxLimit));
    }

    public static IntRange from(String s) {
        try {
            s = s.trim();
            if (s.startsWith("[") && s.endsWith("]")) {
                String innards = s.substring(1, s.length() - 1).trim();
                if (innards.isEmpty()) {
                    return IntRange.empty();
                }
                String[] numbers = (" " + innards + " ").split(",");
                if (numbers.length != 2) {
                    throw new IllegalArgumentException("Expected two numbers");
                }
                return new IntRange(IntRange.parseOptionalInt(numbers[0]), IntRange.parseOptionalInt(numbers[1]));
            }
            OptionalInt fromTo = IntRange.parseOptionalInt(s);
            return new IntRange(fromTo, fromTo);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Expected a number or range on the form [min, max], but got '" + s + "'", e);
        }
    }

    private static OptionalInt parseOptionalInt(String s) {
        try {
            s = s.trim();
            if (s.isEmpty()) {
                return OptionalInt.empty();
            }
            return OptionalInt.of(Integer.parseInt(s));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("'" + s + "' is not an integer");
        }
    }
}

