/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import ai.vespa.validation.PatternedStringWrapper;
import ai.vespa.validation.Validation;
import com.yahoo.config.provision.Zone;
import java.util.regex.Pattern;

public class CloudAccount
extends PatternedStringWrapper<CloudAccount> {
    private static final String EMPTY = "";
    private static final String AWS_ACCOUNT_ID = "[0-9]{12}";
    private static final Pattern AWS_ACCOUNT_ID_PATTERN = Pattern.compile("[0-9]{12}");
    private static final String GCP_PROJECT_ID = "[a-z][a-z0-9-]{4,28}[a-z0-9]";
    private static final Pattern GCP_PROJECT_ID_PATTERN = Pattern.compile("[a-z][a-z0-9-]{4,28}[a-z0-9]");
    public static final CloudAccount empty = new CloudAccount("", "", "cloud account");

    public static void requireAwsAccountId(String accountId) {
        Validation.requireMatch((String)accountId, (String)"AWS account ID", (Pattern)AWS_ACCOUNT_ID_PATTERN);
    }

    public static void requireGcpProjectId(String projectId) {
        Validation.requireMatch((String)projectId, (String)"GCP project ID", (Pattern)GCP_PROJECT_ID_PATTERN);
    }

    private CloudAccount(String value, String regex, String description) {
        super(value, Pattern.compile("^(" + regex + ")$"), description);
    }

    public boolean isUnspecified() {
        return this.equals((Object)empty);
    }

    public boolean isEnclave(Zone zone) {
        return !this.isUnspecified() && zone.system().isPublic() && !this.equals((Object)zone.cloud().account());
    }

    public void requireAwsAccountId() {
        CloudAccount.requireAwsAccountId(this.value());
    }

    public void requireGcpProjectId() {
        CloudAccount.requireGcpProjectId(this.value());
    }

    public static CloudAccount from(String cloudAccount) {
        return switch (cloudAccount) {
            case EMPTY, "default" -> empty;
            default -> new CloudAccount(cloudAccount, "[0-9]{12}|[a-z][a-z0-9-]{4,28}[a-z0-9]", "cloud account");
        };
    }

    public String toString() {
        return this.isUnspecified() ? "unspecified account" : "account '" + this.value() + "'";
    }
}

