/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.zone;

import com.yahoo.config.provision.zone.ZoneApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class UpgradePolicy {
    private final List<Set<ZoneApi>> steps;

    private UpgradePolicy(List<Set<ZoneApi>> steps) {
        for (int i = 0; i < steps.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (Collections.disjoint((Collection)steps.get(i), (Collection)steps.get(j))) continue;
                throw new IllegalArgumentException("One or more zones are declared in multiple steps");
            }
        }
        this.steps = List.copyOf(steps);
    }

    public List<Set<ZoneApi>> steps() {
        return this.steps;
    }

    public UpgradePolicy inverted() {
        ArrayList<Set<ZoneApi>> copy = new ArrayList<Set<ZoneApi>>(this.steps);
        Collections.reverse(copy);
        return new UpgradePolicy(copy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Set<ZoneApi>> steps = new ArrayList<Set<ZoneApi>>();

        private Builder() {
        }

        public Builder upgrade(ZoneApi zone) {
            return this.upgradeInParallel(zone);
        }

        public Builder upgradeInParallel(ZoneApi ... zone) {
            this.steps.add(Set.of(zone));
            return this;
        }

        public UpgradePolicy build() {
            return new UpgradePolicy(this.steps);
        }
    }
}

