/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.EnumSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SystemName {
    cd(false, true),
    main(false, false),
    Public(true, false),
    PublicCd(true, true),
    dev(false, false);

    private final boolean isPublic;
    private final boolean isCd;

    private SystemName(boolean isPublic, boolean isCd) {
        this.isPublic = isPublic;
        this.isCd = isCd;
    }

    public static SystemName defaultSystem() {
        return main;
    }

    public static SystemName from(String value) {
        switch (value.toLowerCase()) {
            case "dev": {
                return dev;
            }
            case "cd": {
                return cd;
            }
            case "main": {
                return main;
            }
            case "public": {
                return Public;
            }
            case "publiccd": {
                return PublicCd;
            }
        }
        throw new IllegalArgumentException(String.format("'%s' is not a valid system", value));
    }

    public String value() {
        switch (this) {
            case dev: {
                return "dev";
            }
            case cd: {
                return "cd";
            }
            case main: {
                return "main";
            }
            case Public: {
                return "public";
            }
            case PublicCd: {
                return "publiccd";
            }
        }
        throw new IllegalStateException();
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isCd() {
        return this.isCd;
    }

    public static Set<SystemName> all() {
        return EnumSet.allOf(SystemName.class);
    }

    public static Set<SystemName> allOf(Predicate<SystemName> predicate) {
        return Stream.of(SystemName.values()).filter(predicate).collect(Collectors.toUnmodifiableSet());
    }
}

