/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.Objects;
import java.util.Optional;

public class NodeResources {
    private final double vcpu;
    private final double memoryGb;
    private final double diskGb;
    private final DiskSpeed diskSpeed;
    private final boolean allocateByLegacyName;
    private final String legacyName;

    public NodeResources(double vcpu, double memoryGb, double diskGb) {
        this(vcpu, memoryGb, diskGb, DiskSpeed.fast);
    }

    public NodeResources(double vcpu, double memoryGb, double diskGb, DiskSpeed diskSpeed) {
        this.vcpu = vcpu;
        this.memoryGb = memoryGb;
        this.diskGb = diskGb;
        this.diskSpeed = diskSpeed;
        this.allocateByLegacyName = false;
        this.legacyName = null;
    }

    private NodeResources(double vcpu, double memoryGb, double diskGb, DiskSpeed diskSpeed, boolean allocateByLegacyName, String legacyName) {
        this.vcpu = vcpu;
        this.memoryGb = memoryGb;
        this.diskGb = diskGb;
        this.diskSpeed = diskSpeed;
        this.allocateByLegacyName = allocateByLegacyName;
        this.legacyName = legacyName;
    }

    public double vcpu() {
        return this.vcpu;
    }

    public double memoryGb() {
        return this.memoryGb;
    }

    public double diskGb() {
        return this.diskGb;
    }

    public DiskSpeed diskSpeed() {
        return this.diskSpeed;
    }

    public NodeResources withDiskSpeed(DiskSpeed speed) {
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, speed);
    }

    public NodeResources withVcpu(double vcpu) {
        return new NodeResources(vcpu, this.memoryGb, this.diskGb, this.diskSpeed);
    }

    public NodeResources subtract(NodeResources other) {
        if (!this.isInterchangeableWith(other)) {
            throw new IllegalArgumentException(this + " and " + other + " are not interchangeable");
        }
        return new NodeResources(this.vcpu - other.vcpu, this.memoryGb - other.memoryGb, this.diskGb - other.diskGb, this.combine(this.diskSpeed, other.diskSpeed));
    }

    public NodeResources add(NodeResources other) {
        if (!this.isInterchangeableWith(other)) {
            throw new IllegalArgumentException(this + " and " + other + " are not interchangeable");
        }
        return new NodeResources(this.vcpu + other.vcpu, this.memoryGb + other.memoryGb, this.diskGb + other.diskGb, this.combine(this.diskSpeed, other.diskSpeed));
    }

    public boolean allocateByLegacyName() {
        return this.allocateByLegacyName;
    }

    public Optional<String> legacyName() {
        return Optional.ofNullable(this.legacyName);
    }

    private boolean isInterchangeableWith(NodeResources other) {
        if (this.allocateByLegacyName != other.allocateByLegacyName) {
            return false;
        }
        if (this.allocateByLegacyName) {
            return this.legacyName.equals(other.legacyName);
        }
        return this.diskSpeed == DiskSpeed.any || other.diskSpeed == DiskSpeed.any || this.diskSpeed == other.diskSpeed;
    }

    private DiskSpeed combine(DiskSpeed a, DiskSpeed b) {
        if (a == DiskSpeed.any) {
            return b;
        }
        if (b == DiskSpeed.any) {
            return a;
        }
        if (a == b) {
            return a;
        }
        throw new IllegalArgumentException(a + " cannot be combined with " + b);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeResources)) {
            return false;
        }
        NodeResources other = (NodeResources)o;
        if (this.allocateByLegacyName) {
            return this.legacyName.equals(other.legacyName);
        }
        if (this.vcpu != other.vcpu) {
            return false;
        }
        if (this.memoryGb != other.memoryGb) {
            return false;
        }
        if (this.diskGb != other.diskGb) {
            return false;
        }
        return this.diskSpeed == other.diskSpeed;
    }

    public int hashCode() {
        if (this.allocateByLegacyName) {
            return this.legacyName.hashCode();
        }
        return (int)(2503.0 * this.vcpu + 22123.0 * this.memoryGb + 26987.0 * this.diskGb + (double)this.diskSpeed.hashCode());
    }

    public String toString() {
        if (this.allocateByLegacyName) {
            return "flavor '" + this.legacyName + "'";
        }
        return "[vcpu: " + this.vcpu + ", memory: " + this.memoryGb + " Gb, disk " + this.diskGb + " Gb" + (String)(this.diskSpeed != DiskSpeed.fast ? ", disk speed: " + this.diskSpeed : "") + "]";
    }

    public boolean satisfies(NodeResources other) {
        if (this.allocateByLegacyName || other.allocateByLegacyName) {
            return Objects.equals(this.legacyName, other.legacyName);
        }
        if (this.vcpu < other.vcpu) {
            return false;
        }
        if (this.memoryGb < other.memoryGb) {
            return false;
        }
        if (this.diskGb < other.diskGb) {
            return false;
        }
        return other.diskSpeed == DiskSpeed.any || other.diskSpeed == this.diskSpeed;
    }

    public boolean compatibleWith(NodeResources other) {
        if (this.allocateByLegacyName || other.allocateByLegacyName) {
            return Objects.equals(this.legacyName, other.legacyName);
        }
        if (this.vcpu != other.vcpu) {
            return false;
        }
        if (this.memoryGb != other.memoryGb) {
            return false;
        }
        if (this.diskGb != other.diskGb) {
            return false;
        }
        return other.diskSpeed == DiskSpeed.any || other.diskSpeed == this.diskSpeed;
    }

    public static NodeResources fromLegacyName(String flavorString) {
        if (flavorString.startsWith("d-")) {
            String[] parts = flavorString.split("-");
            double cpu = Integer.parseInt(parts[1]);
            double mem = Integer.parseInt(parts[2]);
            double dsk = Integer.parseInt(parts[3]);
            if (cpu == 0.0) {
                cpu = 0.5;
            }
            if (cpu == 2.0 && mem == 8.0) {
                cpu = 1.5;
            }
            if (cpu == 2.0 && mem == 12.0) {
                cpu = 2.3;
            }
            return new NodeResources(cpu, mem, dsk, DiskSpeed.fast, false, flavorString);
        }
        return new NodeResources(0.0, 0.0, 0.0, DiskSpeed.fast, true, flavorString);
    }

    public static enum DiskSpeed {
        fast,
        slow,
        any;

    }
}

