/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provisioning.FlavorsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Flavor {
    private boolean configured;
    private final String name;
    private final int cost;
    private final boolean isStock;
    private final Type type;
    private final double bandwidth;
    private final boolean retired;
    private List<Flavor> replacesFlavors;
    private NodeResources resources;

    public Flavor(FlavorsConfig.Flavor flavorConfig) {
        this.configured = true;
        this.name = flavorConfig.name();
        this.cost = flavorConfig.cost();
        this.isStock = flavorConfig.stock();
        this.type = Type.valueOf(flavorConfig.environment());
        this.resources = new NodeResources(flavorConfig.minCpuCores(), flavorConfig.minMainMemoryAvailableGb(), flavorConfig.minDiskAvailableGb(), flavorConfig.fastDisk() ? NodeResources.DiskSpeed.fast : NodeResources.DiskSpeed.slow);
        this.bandwidth = flavorConfig.bandwidth();
        this.retired = flavorConfig.retired();
        this.replacesFlavors = new ArrayList<Flavor>();
    }

    public Flavor(NodeResources resources) {
        Objects.requireNonNull(resources, "Resources cannot be null");
        if (resources.allocateByLegacyName()) {
            throw new IllegalArgumentException("Can not create flavor '" + resources.legacyName() + "' from a flavor: Non-docker flavors must be of a configured flavor");
        }
        this.configured = false;
        this.name = resources.legacyName().orElse(resources.toString());
        this.cost = 0;
        this.isStock = true;
        this.type = Type.DOCKER_CONTAINER;
        this.bandwidth = 1.0;
        this.retired = false;
        this.replacesFlavors = List.of();
        this.resources = resources;
    }

    public String name() {
        return this.name;
    }

    public int cost() {
        return this.cost;
    }

    public boolean isStock() {
        return this.isStock;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    public NodeResources resources() {
        return this.resources;
    }

    public double getMinMainMemoryAvailableGb() {
        return this.resources.memoryGb();
    }

    public double getMinDiskAvailableGb() {
        return this.resources.diskGb();
    }

    public boolean hasFastDisk() {
        return this.resources.diskSpeed() == NodeResources.DiskSpeed.fast;
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public double getMinCpuCores() {
        return this.resources.vcpu();
    }

    public boolean isRetired() {
        return this.retired;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDocker() {
        return this.type == Type.DOCKER_CONTAINER;
    }

    public String canonicalName() {
        return this.isCanonical() ? this.name : this.replacesFlavors.get(0).canonicalName();
    }

    public boolean isCanonical() {
        return this.replacesFlavors.size() != 1;
    }

    public List<Flavor> replaces() {
        return this.replacesFlavors;
    }

    public boolean satisfies(Flavor flavor) {
        if (this.equals(flavor)) {
            return true;
        }
        if (this.retired) {
            return false;
        }
        for (Flavor replaces : this.replacesFlavors) {
            if (!replaces.satisfies(flavor)) continue;
            return true;
        }
        return false;
    }

    public void freeze() {
        this.replacesFlavors = List.copyOf(this.replacesFlavors);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Flavor)) {
            return false;
        }
        Flavor other = (Flavor)o;
        if (this.configured) {
            return other.name.equals(this.name);
        }
        return this.resources.equals(other.resources);
    }

    public String toString() {
        if (this.isConfigured()) {
            return "flavor '" + this.name + "'";
        }
        return this.name;
    }

    public static enum Type {
        undefined,
        BARE_METAL,
        VIRTUAL_MACHINE,
        DOCKER_CONTAINER;

    }
}

