/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.google.inject.Inject;
import com.yahoo.config.provision.Flavor;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provisioning.FlavorsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class NodeFlavors {
    private final Map<String, Flavor> configuredFlavors;

    @Inject
    public NodeFlavors(FlavorsConfig config) {
        HashMap<String, Flavor> b = new HashMap<String, Flavor>();
        for (Flavor flavor : NodeFlavors.toFlavors(config)) {
            b.put(flavor.name(), flavor);
        }
        this.configuredFlavors = Collections.unmodifiableMap(b);
    }

    public List<Flavor> getFlavors() {
        return new ArrayList<Flavor>(this.configuredFlavors.values());
    }

    public Optional<Flavor> getFlavor(String name) {
        if (this.configuredFlavors.containsKey(name)) {
            return Optional.of(this.configuredFlavors.get(name));
        }
        NodeResources nodeResources = NodeResources.fromLegacyName(name);
        if (nodeResources.allocateByLegacyName()) {
            return Optional.empty();
        }
        return Optional.of(new Flavor(nodeResources));
    }

    public Flavor getFlavorOrThrow(String flavorName) {
        return this.getFlavor(flavorName).orElseThrow(() -> new IllegalArgumentException("Unknown flavor '" + flavorName + "'. Flavors are " + this.canonicalFlavorNames()));
    }

    public boolean exists(String flavorName) {
        return this.getFlavor(flavorName).isPresent();
    }

    private List<String> canonicalFlavorNames() {
        return this.configuredFlavors.values().stream().map(Flavor::canonicalName).distinct().sorted().collect(Collectors.toList());
    }

    private static Collection<Flavor> toFlavors(FlavorsConfig config) {
        HashMap<String, Flavor> flavors = new HashMap<String, Flavor>();
        for (FlavorsConfig.Flavor flavorConfig : config.flavor()) {
            flavors.put(flavorConfig.name(), new Flavor(flavorConfig));
        }
        for (FlavorsConfig.Flavor flavorConfig : config.flavor()) {
            Flavor flavor = (Flavor)flavors.get(flavorConfig.name());
            for (FlavorsConfig.Flavor.Replaces flavorReplacesConfig : flavorConfig.replaces()) {
                if (!flavors.containsKey(flavorReplacesConfig.name())) {
                    throw new IllegalStateException("Replaces for " + flavor.name() + " pointing to a non existing flavor: " + flavorReplacesConfig.name());
                }
                flavor.replaces().add((Flavor)flavors.get(flavorReplacesConfig.name()));
            }
            flavor.freeze();
        }
        for (Flavor flavor : flavors.values()) {
            if (!flavor.isRetired() || NodeFlavors.hasReplacement(flavors.values(), flavor)) continue;
            throw new IllegalStateException(String.format("Flavor '%s' is retired, but has no replacement", flavor.name()));
        }
        return flavors.values();
    }

    private static boolean hasReplacement(Collection<Flavor> flavors, Flavor flavor) {
        return flavors.stream().filter(f -> !f.equals(flavor)).anyMatch(f -> f.satisfies(flavor));
    }
}

