/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

public enum NodeType {
    tenant(null, "Tenant node"),
    host(tenant, "Tenant docker host"),
    proxy(null, "Proxy node"),
    proxyhost(proxy, "Proxy docker host"),
    config(null, "Config server"),
    confighost(config, "Config docker host"),
    controller(null, "Controller"),
    controllerhost(controller, "Controller host");

    private final NodeType childNodeType;
    private final String description;

    private NodeType(NodeType childNodeType, String description) {
        this.childNodeType = childNodeType;
        this.description = description;
    }

    public boolean isDockerHost() {
        return this.childNodeType != null;
    }

    public String description() {
        return this.description;
    }

    public NodeType childNodeType() {
        if (!this.isDockerHost()) {
            throw new IllegalStateException(this + " has no children");
        }
        return this.childNodeType;
    }
}

