/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provisioning;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.StringNode;
import java.util.HashSet;
import java.util.Set;

public final class NodeRepositoryConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "b50d5010289c5b83277d6dc7fb3db379";
    public static final String CONFIG_DEF_NAME = "node-repository";
    public static final String CONFIG_DEF_NAMESPACE = "config.provisioning";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=config.provisioning", "dockerImage string default=\"dummyImage\"", "useCuratorClientCache bool default=false", "hostnameWhitelist string default=\"\""};
    private final StringNode dockerImage;
    private final BooleanNode useCuratorClientCache;
    private final StringNode hostnameWhitelist;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public NodeRepositoryConfig(Builder builder) {
        this(builder, true);
    }

    private NodeRepositoryConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for node-repository must be initialized: " + builder.__uninitialized);
        }
        this.dockerImage = builder.dockerImage == null ? new StringNode("dummyImage") : new StringNode(builder.dockerImage);
        this.useCuratorClientCache = builder.useCuratorClientCache == null ? new BooleanNode(false) : new BooleanNode(builder.useCuratorClientCache.booleanValue());
        this.hostnameWhitelist = builder.hostnameWhitelist == null ? new StringNode(CONFIG_DEF_VERSION) : new StringNode(builder.hostnameWhitelist);
    }

    public String dockerImage() {
        return this.dockerImage.value();
    }

    public boolean useCuratorClientCache() {
        return this.useCuratorClientCache.value();
    }

    public String hostnameWhitelist() {
        return this.hostnameWhitelist.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(NodeRepositoryConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String dockerImage = null;
        private Boolean useCuratorClientCache = null;
        private String hostnameWhitelist = null;

        public Builder() {
        }

        public Builder(NodeRepositoryConfig config) {
            this.dockerImage(config.dockerImage());
            this.useCuratorClientCache(config.useCuratorClientCache());
            this.hostnameWhitelist(config.hostnameWhitelist());
        }

        private Builder override(Builder __superior) {
            if (__superior.dockerImage != null) {
                this.dockerImage(__superior.dockerImage);
            }
            if (__superior.useCuratorClientCache != null) {
                this.useCuratorClientCache(__superior.useCuratorClientCache);
            }
            if (__superior.hostnameWhitelist != null) {
                this.hostnameWhitelist(__superior.hostnameWhitelist);
            }
            return this;
        }

        public Builder dockerImage(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.dockerImage = __value;
            return this;
        }

        public Builder useCuratorClientCache(boolean __value) {
            this.useCuratorClientCache = __value;
            return this;
        }

        private Builder useCuratorClientCache(String __value) {
            return this.useCuratorClientCache(Boolean.valueOf(__value));
        }

        public Builder hostnameWhitelist(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.hostnameWhitelist = __value;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return NodeRepositoryConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return NodeRepositoryConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return NodeRepositoryConfig.CONFIG_DEF_NAMESPACE;
        }

        public NodeRepositoryConfig build() {
            return new NodeRepositoryConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

