/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.google.inject.Inject;
import com.yahoo.cloud.config.ConfigserverConfig;
import com.yahoo.config.provision.Cloud;
import com.yahoo.config.provision.CloudName;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.SystemName;
import com.yahoo.config.provisioning.CloudConfig;
import java.util.Objects;

public class Zone {
    private final Cloud cloud;
    private final SystemName systemName;
    private final Environment environment;
    private final RegionName region;

    @Inject
    public Zone(ConfigserverConfig configserverConfig, CloudConfig cloudConfig) {
        this(Cloud.builder().name(CloudName.from(configserverConfig.cloud())).dynamicProvisioning(cloudConfig.dynamicProvisioning()).reprovisionToUpgradeOs(cloudConfig.reprovisionToUpgradeOs()).requireAccessControl(cloudConfig.requireAccessControl()).build(), SystemName.from(configserverConfig.system()), Environment.from(configserverConfig.environment()), RegionName.from(configserverConfig.region()));
    }

    public Zone(Environment environment, RegionName region) {
        this(SystemName.defaultSystem(), environment, region);
    }

    public Zone(SystemName systemName, Environment environment, RegionName region) {
        this(Cloud.defaultCloud(), systemName, environment, region);
    }

    public Zone(Cloud cloud, SystemName systemName, Environment environment, RegionName region) {
        this.cloud = cloud;
        this.systemName = systemName;
        this.environment = environment;
        this.region = region;
    }

    public Cloud getCloud() {
        return this.cloud;
    }

    public SystemName system() {
        return this.systemName;
    }

    public Environment environment() {
        return this.environment;
    }

    public RegionName region() {
        return this.region;
    }

    public String systemLocalValue() {
        return this.environment + "." + this.region;
    }

    public static Zone defaultZone() {
        return new Zone(Cloud.defaultCloud(), SystemName.defaultSystem(), Environment.defaultEnvironment(), RegionName.defaultName());
    }

    public String toString() {
        return "zone " + this.environment + "." + this.region;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Zone)) {
            return false;
        }
        Zone zone = (Zone)o;
        return this.environment == zone.environment && Objects.equals((Object)this.region, (Object)zone.region);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.environment, this.region});
    }
}

