/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.Objects;
import java.util.Optional;

public class NodeResources {
    private static final double cpuUnitCost = 0.09;
    private static final double memoryUnitCost = 0.009;
    private static final double diskUnitCost = 3.0E-4;
    private static final NodeResources zero = new NodeResources(0.0, 0.0, 0.0, 0.0);
    private static final NodeResources unspecified = new NodeResources(0.0, 0.0, 0.0, 0.0);
    private final double vcpu;
    private final double memoryGb;
    private final double diskGb;
    private final double bandwidthGbps;
    private final DiskSpeed diskSpeed;
    private final StorageType storageType;
    private final Architecture architecture;

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps) {
        this(vcpu, memoryGb, diskGb, bandwidthGbps, DiskSpeed.getDefault());
    }

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps, DiskSpeed diskSpeed) {
        this(vcpu, memoryGb, diskGb, bandwidthGbps, diskSpeed, StorageType.getDefault(), Architecture.getDefault());
    }

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps, DiskSpeed diskSpeed, StorageType storageType) {
        this(vcpu, memoryGb, diskGb, bandwidthGbps, diskSpeed, storageType, Architecture.getDefault());
    }

    public NodeResources(double vcpu, double memoryGb, double diskGb, double bandwidthGbps, DiskSpeed diskSpeed, StorageType storageType, Architecture architecture) {
        this.vcpu = this.validate(vcpu, "vcpu");
        this.memoryGb = this.validate(memoryGb, "memory");
        this.diskGb = this.validate(diskGb, "disk");
        this.bandwidthGbps = this.validate(bandwidthGbps, "bandwidth");
        this.diskSpeed = diskSpeed;
        this.storageType = storageType;
        this.architecture = architecture;
    }

    public double vcpu() {
        return this.vcpu;
    }

    public double memoryGb() {
        return this.memoryGb;
    }

    public double diskGb() {
        return this.diskGb;
    }

    public double bandwidthGbps() {
        return this.bandwidthGbps;
    }

    public DiskSpeed diskSpeed() {
        return this.diskSpeed;
    }

    public StorageType storageType() {
        return this.storageType;
    }

    public Architecture architecture() {
        return this.architecture;
    }

    public double cost() {
        return this.vcpu * 0.09 + this.memoryGb * 0.009 + this.diskGb * 3.0E-4;
    }

    public NodeResources withVcpu(double vcpu) {
        this.ensureSpecified();
        if (vcpu == this.vcpu) {
            return this;
        }
        return new NodeResources(vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, this.architecture);
    }

    public NodeResources withMemoryGb(double memoryGb) {
        this.ensureSpecified();
        if (memoryGb == this.memoryGb) {
            return this;
        }
        return new NodeResources(this.vcpu, memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, this.architecture);
    }

    public NodeResources withDiskGb(double diskGb) {
        this.ensureSpecified();
        if (diskGb == this.diskGb) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, this.architecture);
    }

    public NodeResources withBandwidthGbps(double bandwidthGbps) {
        this.ensureSpecified();
        if (bandwidthGbps == this.bandwidthGbps) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, bandwidthGbps, this.diskSpeed, this.storageType, this.architecture);
    }

    public NodeResources with(DiskSpeed diskSpeed) {
        this.ensureSpecified();
        if (diskSpeed == this.diskSpeed) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, diskSpeed, this.storageType, this.architecture);
    }

    public NodeResources with(StorageType storageType) {
        this.ensureSpecified();
        if (storageType == this.storageType) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, storageType, this.architecture);
    }

    public NodeResources with(Architecture architecture) {
        this.ensureSpecified();
        if (architecture == this.architecture) {
            return this;
        }
        return new NodeResources(this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, architecture);
    }

    public NodeResources justNumbers() {
        if (this.isUnspecified()) {
            return NodeResources.unspecified();
        }
        return this.with(DiskSpeed.any).with(StorageType.any).with(Architecture.any);
    }

    public NodeResources justNonNumbers() {
        if (this.isUnspecified()) {
            return NodeResources.unspecified();
        }
        return this.withVcpu(0.0).withMemoryGb(0.0).withDiskGb(0.0).withBandwidthGbps(0.0);
    }

    public NodeResources subtract(NodeResources other) {
        this.ensureSpecified();
        other.ensureSpecified();
        if (!this.isInterchangeableWith(other)) {
            throw new IllegalArgumentException(this + " and " + other + " are not interchangeable");
        }
        return new NodeResources(this.vcpu - other.vcpu, this.memoryGb - other.memoryGb, this.diskGb - other.diskGb, this.bandwidthGbps - other.bandwidthGbps, this.diskSpeed.combineWith(other.diskSpeed), this.storageType.combineWith(other.storageType), this.architecture.combineWith(other.architecture));
    }

    public NodeResources add(NodeResources other) {
        this.ensureSpecified();
        if (!this.isInterchangeableWith(other)) {
            throw new IllegalArgumentException(this + " and " + other + " are not interchangeable");
        }
        return new NodeResources(this.vcpu + other.vcpu, this.memoryGb + other.memoryGb, this.diskGb + other.diskGb, this.bandwidthGbps + other.bandwidthGbps, this.diskSpeed.combineWith(other.diskSpeed), this.storageType.combineWith(other.storageType), this.architecture.combineWith(other.architecture));
    }

    private boolean isInterchangeableWith(NodeResources other) {
        this.ensureSpecified();
        other.ensureSpecified();
        if (this.diskSpeed != DiskSpeed.any && other.diskSpeed != DiskSpeed.any && this.diskSpeed != other.diskSpeed) {
            return false;
        }
        if (this.storageType != StorageType.any && other.storageType != StorageType.any && this.storageType != other.storageType) {
            return false;
        }
        return this.architecture == Architecture.any || other.architecture == Architecture.any || this.architecture == other.architecture;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeResources)) {
            return false;
        }
        NodeResources other = (NodeResources)o;
        if (!this.equal(this.vcpu, other.vcpu)) {
            return false;
        }
        if (!this.equal(this.memoryGb, other.memoryGb)) {
            return false;
        }
        if (!this.equal(this.diskGb, other.diskGb)) {
            return false;
        }
        if (!this.equal(this.bandwidthGbps, other.bandwidthGbps)) {
            return false;
        }
        if (this.diskSpeed != other.diskSpeed) {
            return false;
        }
        if (this.storageType != other.storageType) {
            return false;
        }
        return this.architecture == other.architecture;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.vcpu, this.memoryGb, this.diskGb, this.bandwidthGbps, this.diskSpeed, this.storageType, this.architecture});
    }

    private static StringBuilder appendDouble(StringBuilder sb, double d) {
        long x10 = Math.round(d * 10.0);
        sb.append(x10 / 10L).append('.').append(x10 % 10L);
        return sb;
    }

    public String toString() {
        if (this.isUnspecified()) {
            return "unspecified resources";
        }
        StringBuilder sb = new StringBuilder("[vcpu: ");
        NodeResources.appendDouble(sb, this.vcpu);
        sb.append(", memory: ");
        NodeResources.appendDouble(sb, this.memoryGb);
        sb.append(" Gb, disk ");
        NodeResources.appendDouble(sb, this.diskGb);
        sb.append(" Gb");
        if (this.bandwidthGbps > 0.0) {
            sb.append(", bandwidth: ");
            NodeResources.appendDouble(sb, this.bandwidthGbps);
            sb.append(" Gbps");
        }
        if (!this.diskSpeed.isDefault()) {
            sb.append(", disk speed: ").append((Object)this.diskSpeed);
        }
        if (!this.storageType.isDefault()) {
            sb.append(", storage type: ").append((Object)this.storageType);
        }
        sb.append(", architecture: ").append((Object)this.architecture);
        sb.append(']');
        return sb.toString();
    }

    public boolean satisfies(NodeResources other) {
        this.ensureSpecified();
        other.ensureSpecified();
        if (this.vcpu < other.vcpu) {
            return false;
        }
        if (this.memoryGb < other.memoryGb) {
            return false;
        }
        if (this.diskGb < other.diskGb) {
            return false;
        }
        if (this.bandwidthGbps < other.bandwidthGbps) {
            return false;
        }
        if (other.diskSpeed != DiskSpeed.any && other.diskSpeed != this.diskSpeed) {
            return false;
        }
        if (other.storageType != StorageType.any && other.storageType != this.storageType) {
            return false;
        }
        return other.architecture == Architecture.any || other.architecture == this.architecture;
    }

    public boolean compatibleWith(NodeResources other) {
        if (!this.equal(this.vcpu, other.vcpu)) {
            return false;
        }
        if (!this.equal(this.memoryGb, other.memoryGb)) {
            return false;
        }
        if (!this.equal(this.diskGb, other.diskGb)) {
            return false;
        }
        if (!this.equal(this.bandwidthGbps, other.bandwidthGbps)) {
            return false;
        }
        if (!this.diskSpeed.compatibleWith(other.diskSpeed)) {
            return false;
        }
        if (!this.storageType.compatibleWith(other.storageType)) {
            return false;
        }
        return this.architecture.compatibleWith(other.architecture);
    }

    public static NodeResources unspecified() {
        return unspecified;
    }

    public boolean isUnspecified() {
        return this == unspecified;
    }

    private void ensureSpecified() {
        if (this.isUnspecified()) {
            throw new IllegalStateException("Cannot perform this on unspecified resources");
        }
    }

    public double distanceTo(NodeResources other) {
        if (!this.diskSpeed().compatibleWith(other.diskSpeed())) {
            return Double.MAX_VALUE;
        }
        if (!this.storageType().compatibleWith(other.storageType())) {
            return Double.MAX_VALUE;
        }
        double distance = Math.pow(this.vcpu() - other.vcpu(), 2.0) + Math.pow(this.memoryGb() - other.memoryGb(), 2.0);
        if (this.storageType() == StorageType.local || other.storageType() == StorageType.local) {
            distance += Math.pow(this.diskGb() - other.diskGb(), 2.0);
        }
        return distance;
    }

    public Optional<NodeResources> asOptional() {
        return this.isUnspecified() ? Optional.empty() : Optional.of(this);
    }

    private boolean equal(double a, double b) {
        return Math.abs(a - b) < 1.0E-8;
    }

    public static NodeResources fromLegacyName(String name) {
        if (!name.startsWith("d-")) {
            throw new IllegalArgumentException("A node specification string must start by 'd-' but was '" + name + "'");
        }
        String[] parts = name.split("-");
        if (parts.length != 4) {
            throw new IllegalArgumentException("A node specification string must contain three numbers separated by '-' but was '" + name + "'");
        }
        double cpu = Integer.parseInt(parts[1]);
        double mem = Integer.parseInt(parts[2]);
        double dsk = Integer.parseInt(parts[3]);
        if (cpu == 0.0) {
            cpu = 0.5;
        }
        if (cpu == 2.0 && mem == 8.0) {
            cpu = 1.5;
        }
        if (cpu == 2.0 && mem == 12.0) {
            cpu = 2.3;
        }
        return new NodeResources(cpu, mem, dsk, 0.3, DiskSpeed.getDefault(), StorageType.getDefault(), Architecture.x86_64);
    }

    private double validate(double value, String valueName) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException(valueName + " cannot be NaN");
        }
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException(valueName + " cannot be infinite");
        }
        return value;
    }

    public static NodeResources zero() {
        return zero;
    }

    public static enum Architecture {
        x86_64,
        arm64,
        any;


        public static int compare(Architecture a, Architecture b) {
            if (a == any) {
                a = x86_64;
            }
            if (b == any) {
                b = x86_64;
            }
            if (a == x86_64 && b == arm64) {
                return -1;
            }
            if (a == arm64 && b == x86_64) {
                return 1;
            }
            return 0;
        }

        public boolean compatibleWith(Architecture other) {
            return this == any || other == any || other == this;
        }

        private Architecture combineWith(Architecture other) {
            if (this == any) {
                return other;
            }
            if (other == any) {
                return this;
            }
            if (this == other) {
                return this;
            }
            throw new IllegalArgumentException(this + " cannot be combined with " + other);
        }

        public boolean isDefault() {
            return this == Architecture.getDefault();
        }

        public static Architecture getDefault() {
            return x86_64;
        }
    }

    public static enum StorageType {
        remote,
        local,
        any;


        public static int compare(StorageType a, StorageType b) {
            if (a == any) {
                a = remote;
            }
            if (b == any) {
                b = remote;
            }
            if (a == remote && b == local) {
                return -1;
            }
            if (a == local && b == remote) {
                return 1;
            }
            return 0;
        }

        public boolean compatibleWith(StorageType other) {
            return this == any || other == any || other == this;
        }

        private StorageType combineWith(StorageType other) {
            if (this == any) {
                return other;
            }
            if (other == any) {
                return this;
            }
            if (this == other) {
                return this;
            }
            throw new IllegalArgumentException(this + " cannot be combined with " + other);
        }

        public boolean isDefault() {
            return this == StorageType.getDefault();
        }

        public static StorageType getDefault() {
            return any;
        }
    }

    public static enum DiskSpeed {
        fast,
        slow,
        any;


        public static int compare(DiskSpeed a, DiskSpeed b) {
            if (a == any) {
                a = slow;
            }
            if (b == any) {
                b = slow;
            }
            if (a == slow && b == fast) {
                return -1;
            }
            if (a == fast && b == slow) {
                return 1;
            }
            return 0;
        }

        public boolean compatibleWith(DiskSpeed other) {
            return this == any || other == any || other == this;
        }

        private DiskSpeed combineWith(DiskSpeed other) {
            if (this == any) {
                return other;
            }
            if (other == any) {
                return this;
            }
            if (this == other) {
                return this;
            }
            throw new IllegalArgumentException(this + " cannot be combined with " + other);
        }

        public boolean isDefault() {
            return this == DiskSpeed.getDefault();
        }

        public static DiskSpeed getDefault() {
            return fast;
        }
    }
}

