/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provisioning;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class FlavorsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "d9328680738fc18e46424643a7e077c3";
    public static final String CONFIG_DEF_NAME = "flavors";
    public static final String CONFIG_DEF_NAMESPACE = "config.provisioning";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=config.provisioning", "flavor[].name string", "flavor[].cost int default=0", "flavor[].environment string default=\"undefined\"", "flavor[].minCpuCores double default=0.0", "flavor[].cpuSpeedup double default=1.0", "flavor[].minMainMemoryAvailableGb double default=0.0", "flavor[].minDiskAvailableGb double default=0.0", "flavor[].fastDisk bool default=true", "flavor[].remoteStorage bool default=true", "flavor[].bandwidth double default=0.0"};
    private final InnerNodeVector<Flavor> flavor;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public FlavorsConfig(Builder builder) {
        this(builder, true);
    }

    private FlavorsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for flavors must be initialized: " + builder.__uninitialized);
        }
        this.flavor = Flavor.createVector(builder.flavor);
    }

    public List<Flavor> flavor() {
        return this.flavor;
    }

    public Flavor flavor(int i) {
        return (Flavor)((Object)this.flavor.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(FlavorsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Flavor
    extends InnerNode {
        private final StringNode name;
        private final IntegerNode cost;
        private final StringNode environment;
        private final DoubleNode minCpuCores;
        private final DoubleNode cpuSpeedup;
        private final DoubleNode minMainMemoryAvailableGb;
        private final DoubleNode minDiskAvailableGb;
        private final BooleanNode fastDisk;
        private final BooleanNode remoteStorage;
        private final DoubleNode bandwidth;

        public Flavor(Builder builder) {
            this(builder, true);
        }

        private Flavor(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for flavors.flavor[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.cost = builder.cost == null ? new IntegerNode(0) : new IntegerNode(builder.cost.intValue());
            this.environment = builder.environment == null ? new StringNode("undefined") : new StringNode(builder.environment);
            this.minCpuCores = builder.minCpuCores == null ? new DoubleNode(0.0) : new DoubleNode(builder.minCpuCores.doubleValue());
            this.cpuSpeedup = builder.cpuSpeedup == null ? new DoubleNode(1.0) : new DoubleNode(builder.cpuSpeedup.doubleValue());
            this.minMainMemoryAvailableGb = builder.minMainMemoryAvailableGb == null ? new DoubleNode(0.0) : new DoubleNode(builder.minMainMemoryAvailableGb.doubleValue());
            this.minDiskAvailableGb = builder.minDiskAvailableGb == null ? new DoubleNode(0.0) : new DoubleNode(builder.minDiskAvailableGb.doubleValue());
            this.fastDisk = builder.fastDisk == null ? new BooleanNode(true) : new BooleanNode(builder.fastDisk.booleanValue());
            this.remoteStorage = builder.remoteStorage == null ? new BooleanNode(true) : new BooleanNode(builder.remoteStorage.booleanValue());
            this.bandwidth = builder.bandwidth == null ? new DoubleNode(0.0) : new DoubleNode(builder.bandwidth.doubleValue());
        }

        public String name() {
            return this.name.value();
        }

        public int cost() {
            return this.cost.value();
        }

        public String environment() {
            return this.environment.value();
        }

        public double minCpuCores() {
            return this.minCpuCores.value();
        }

        public double cpuSpeedup() {
            return this.cpuSpeedup.value();
        }

        public double minMainMemoryAvailableGb() {
            return this.minMainMemoryAvailableGb.value();
        }

        public double minDiskAvailableGb() {
            return this.minDiskAvailableGb.value();
        }

        public boolean fastDisk() {
            return this.fastDisk.value();
        }

        public boolean remoteStorage() {
            return this.remoteStorage.value();
        }

        public double bandwidth() {
            return this.bandwidth.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Flavor newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("flavor");
            return changes;
        }

        private static InnerNodeVector<Flavor> createVector(List<Builder> builders) {
            ArrayList<Flavor> elems = new ArrayList<Flavor>();
            for (Builder b : builders) {
                elems.add(new Flavor(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name"));
            private String name = null;
            private Integer cost = null;
            private String environment = null;
            private Double minCpuCores = null;
            private Double cpuSpeedup = null;
            private Double minMainMemoryAvailableGb = null;
            private Double minDiskAvailableGb = null;
            private Boolean fastDisk = null;
            private Boolean remoteStorage = null;
            private Double bandwidth = null;

            public Builder() {
            }

            public Builder(Flavor config) {
                this.name(config.name());
                this.cost(config.cost());
                this.environment(config.environment());
                this.minCpuCores(config.minCpuCores());
                this.cpuSpeedup(config.cpuSpeedup());
                this.minMainMemoryAvailableGb(config.minMainMemoryAvailableGb());
                this.minDiskAvailableGb(config.minDiskAvailableGb());
                this.fastDisk(config.fastDisk());
                this.remoteStorage(config.remoteStorage());
                this.bandwidth(config.bandwidth());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.cost != null) {
                    this.cost(__superior.cost);
                }
                if (__superior.environment != null) {
                    this.environment(__superior.environment);
                }
                if (__superior.minCpuCores != null) {
                    this.minCpuCores(__superior.minCpuCores);
                }
                if (__superior.cpuSpeedup != null) {
                    this.cpuSpeedup(__superior.cpuSpeedup);
                }
                if (__superior.minMainMemoryAvailableGb != null) {
                    this.minMainMemoryAvailableGb(__superior.minMainMemoryAvailableGb);
                }
                if (__superior.minDiskAvailableGb != null) {
                    this.minDiskAvailableGb(__superior.minDiskAvailableGb);
                }
                if (__superior.fastDisk != null) {
                    this.fastDisk(__superior.fastDisk);
                }
                if (__superior.remoteStorage != null) {
                    this.remoteStorage(__superior.remoteStorage);
                }
                if (__superior.bandwidth != null) {
                    this.bandwidth(__superior.bandwidth);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder cost(int __value) {
                this.cost = __value;
                return this;
            }

            private Builder cost(String __value) {
                return this.cost(Integer.valueOf(__value));
            }

            public Builder environment(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.environment = __value;
                return this;
            }

            public Builder minCpuCores(double __value) {
                this.minCpuCores = __value;
                return this;
            }

            private Builder minCpuCores(String __value) {
                return this.minCpuCores(Double.valueOf(__value));
            }

            public Builder cpuSpeedup(double __value) {
                this.cpuSpeedup = __value;
                return this;
            }

            private Builder cpuSpeedup(String __value) {
                return this.cpuSpeedup(Double.valueOf(__value));
            }

            public Builder minMainMemoryAvailableGb(double __value) {
                this.minMainMemoryAvailableGb = __value;
                return this;
            }

            private Builder minMainMemoryAvailableGb(String __value) {
                return this.minMainMemoryAvailableGb(Double.valueOf(__value));
            }

            public Builder minDiskAvailableGb(double __value) {
                this.minDiskAvailableGb = __value;
                return this;
            }

            private Builder minDiskAvailableGb(String __value) {
                return this.minDiskAvailableGb(Double.valueOf(__value));
            }

            public Builder fastDisk(boolean __value) {
                this.fastDisk = __value;
                return this;
            }

            private Builder fastDisk(String __value) {
                return this.fastDisk(Boolean.valueOf(__value));
            }

            public Builder remoteStorage(boolean __value) {
                this.remoteStorage = __value;
                return this;
            }

            private Builder remoteStorage(String __value) {
                return this.remoteStorage(Boolean.valueOf(__value));
            }

            public Builder bandwidth(double __value) {
                this.bandwidth = __value;
                return this;
            }

            private Builder bandwidth(String __value) {
                return this.bandwidth(Double.valueOf(__value));
            }

            public Flavor build() {
                return new Flavor(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Flavor.Builder> flavor = new ArrayList<Flavor.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(FlavorsConfig config) {
            for (Flavor f : config.flavor()) {
                this.flavor(new Flavor.Builder(f));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.flavor.isEmpty()) {
                this.flavor.addAll(__superior.flavor);
            }
            return this;
        }

        public Builder flavor(Flavor.Builder __builder) {
            this.flavor.add(__builder);
            return this;
        }

        public Builder flavor(Consumer<Flavor.Builder> __func) {
            Flavor.Builder __inner = new Flavor.Builder();
            __func.accept(__inner);
            this.flavor.add(__inner);
            return this;
        }

        public Builder flavor(List<Flavor.Builder> __builders) {
            this.flavor = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return FlavorsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return FlavorsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return FlavorsConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public FlavorsConfig build() {
            return new FlavorsConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

