/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.zone;

import com.yahoo.config.provision.CloudName;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.SystemName;
import java.util.Objects;

public class ZoneId {
    private final Environment environment;
    private final RegionName region;
    private final CloudName cloud;
    private final SystemName system;

    private ZoneId(Environment environment, RegionName region, CloudName cloud, SystemName system) {
        this.environment = Objects.requireNonNull(environment, "environment must be non-null");
        this.region = Objects.requireNonNull(region, "region must be non-null");
        this.cloud = Objects.requireNonNull(cloud, "cloud must be non-null");
        this.system = Objects.requireNonNull(system, "system must be non-null");
    }

    private ZoneId(Environment environment, RegionName region) {
        this(environment, region, CloudName.defaultName(), SystemName.defaultSystem());
    }

    public static ZoneId from(Environment environment, RegionName region) {
        return new ZoneId(environment, region);
    }

    public static ZoneId from(Environment environment, RegionName region, SystemName system) {
        return new ZoneId(environment, region, CloudName.defaultName(), system);
    }

    public static ZoneId from(Environment environment, RegionName region, CloudName cloud, SystemName system) {
        return new ZoneId(environment, region, cloud, system);
    }

    public static ZoneId from(String environment, String region) {
        return ZoneId.from(Environment.from(environment), RegionName.from(region));
    }

    public static ZoneId from(String value) {
        String[] parts = value.split("\\.");
        switch (parts.length) {
            case 2: {
                return ZoneId.from(parts[0], parts[1]);
            }
            case 4: {
                return ZoneId.from(parts[2], parts[3], parts[0], parts[1]);
            }
        }
        throw new IllegalArgumentException("Cannot deserialize zone id '" + value + "'");
    }

    public static ZoneId from(Environment environment, RegionName region, CloudName cloud) {
        return new ZoneId(environment, region, cloud, SystemName.defaultSystem());
    }

    public static ZoneId from(String environment, String region, String cloud) {
        return new ZoneId(Environment.from(environment), RegionName.from(region), CloudName.from(cloud), SystemName.defaultSystem());
    }

    public static ZoneId from(String environment, String region, String cloud, String system) {
        return new ZoneId(Environment.from(environment), RegionName.from(region), CloudName.from(cloud), SystemName.from(system));
    }

    public Environment environment() {
        return this.environment;
    }

    public RegionName region() {
        return this.region;
    }

    public CloudName cloud() {
        return this.cloud;
    }

    public SystemName system() {
        return this.system;
    }

    public String value() {
        return this.environment + "." + this.region;
    }

    public String toString() {
        return "zone " + this.value() + " in " + this.cloud;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZoneId zoneId = (ZoneId)o;
        return this.environment == zoneId.environment && Objects.equals(this.region, zoneId.region);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.environment, this.region});
    }
}

