/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.zone;

import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import com.yahoo.config.provision.zone.ZoneFilter;
import com.yahoo.config.provision.zone.ZoneId;
import com.yahoo.config.provision.zone.ZoneList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ZoneFilterMock
implements ZoneList {
    private final List<ZoneId> zones;
    private final boolean negate;

    private ZoneFilterMock(List<ZoneId> zones, boolean negate) {
        this.negate = negate;
        this.zones = zones;
    }

    public static ZoneFilter from(Collection<ZoneId> zones) {
        return new ZoneFilterMock(new ArrayList<ZoneId>(zones), false);
    }

    @Override
    public ZoneList not() {
        return new ZoneFilterMock(this.zones, !this.negate);
    }

    @Override
    public ZoneList all() {
        return this.filter(zoneId -> true);
    }

    @Override
    public ZoneList controllerUpgraded() {
        return this.all();
    }

    @Override
    public ZoneList reachable() {
        return this.all();
    }

    @Override
    public ZoneList in(Environment ... environments) {
        return this.filter(zoneId -> new HashSet<Environment>(Arrays.asList(environments)).contains((Object)zoneId.environment()));
    }

    @Override
    public ZoneList in(RegionName ... regions) {
        return this.filter(zoneId -> new HashSet<RegionName>(Arrays.asList(regions)).contains(zoneId.region()));
    }

    @Override
    public ZoneList among(ZoneId ... zones) {
        return this.filter(zoneId -> new HashSet<ZoneId>(Arrays.asList(zones)).contains(zoneId));
    }

    @Override
    public List<ZoneId> ids() {
        return Collections.unmodifiableList(this.zones);
    }

    private ZoneFilterMock filter(Predicate<ZoneId> condition) {
        return new ZoneFilterMock(this.zones.stream().filter(this.negate ? condition.negate() : condition).collect(Collectors.toList()), false);
    }
}

