/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import java.util.EnumSet;
import java.util.Set;

public enum SystemName {
    dev,
    cd,
    main,
    Public,
    PublicCd,
    vaas;


    public static SystemName defaultSystem() {
        return main;
    }

    public static SystemName from(String value) {
        switch (value.toLowerCase()) {
            case "dev": {
                return dev;
            }
            case "cd": {
                return cd;
            }
            case "main": {
                return main;
            }
            case "public": {
                return Public;
            }
            case "publiccd": {
                return PublicCd;
            }
            case "vaas": {
                return vaas;
            }
        }
        throw new IllegalArgumentException(String.format("'%s' is not a valid system", value));
    }

    public String value() {
        switch (this) {
            case dev: {
                return "dev";
            }
            case cd: {
                return "cd";
            }
            case main: {
                return "main";
            }
            case Public: {
                return "public";
            }
            case PublicCd: {
                return "publiccd";
            }
            case vaas: {
                return "vaas";
            }
        }
        throw new IllegalStateException();
    }

    public static Set<SystemName> all() {
        return EnumSet.allOf(SystemName.class);
    }
}

