/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.NodeType;
import java.util.Optional;

public final class Capacity {
    private final int nodeCount;
    private final boolean required;
    private final boolean canFail;
    private final Optional<NodeResources> nodeResources;
    private final NodeType type;

    private Capacity(int nodeCount, Optional<NodeResources> nodeResources, boolean required, boolean canFail, NodeType type) {
        this.nodeCount = nodeCount;
        this.required = required;
        this.canFail = canFail;
        this.nodeResources = nodeResources;
        this.type = type;
    }

    public int nodeCount() {
        return this.nodeCount;
    }

    @Deprecated
    public Optional<String> flavor() {
        if (this.nodeResources().isEmpty()) {
            return Optional.empty();
        }
        return this.nodeResources.get().legacyName();
    }

    public Optional<NodeResources> nodeResources() {
        return this.nodeResources;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean canFail() {
        return this.canFail;
    }

    public NodeType type() {
        return this.type;
    }

    public String toString() {
        return this.nodeCount + " nodes " + (String)(this.nodeResources.isPresent() ? "of flavor " + this.nodeResources.get() : "(default flavor)");
    }

    public static Capacity fromNodeCount(int capacity) {
        return Capacity.fromNodeCount(capacity, Optional.empty(), false, true);
    }

    public static Capacity fromCount(int nodeCount, NodeResources flavor, boolean required, boolean canFail) {
        return new Capacity(nodeCount, Optional.of(flavor), required, canFail, NodeType.tenant);
    }

    public static Capacity fromCount(int nodeCount, Optional<NodeResources> flavor, boolean required, boolean canFail) {
        return new Capacity(nodeCount, flavor, required, canFail, NodeType.tenant);
    }

    public static Capacity fromNodeCount(int nodeCount, Optional<String> flavor, boolean required, boolean canFail) {
        return new Capacity(nodeCount, flavor.map(NodeResources::fromLegacyName), required, canFail, NodeType.tenant);
    }

    public static Capacity fromRequiredNodeType(NodeType type) {
        return new Capacity(0, Optional.empty(), true, false, type);
    }
}

