/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.google.common.collect.ImmutableSet;
import com.yahoo.component.Version;
import com.yahoo.config.provision.ClusterMembership;
import com.yahoo.config.provision.Flavor;
import com.yahoo.config.provision.HostSpec;
import com.yahoo.config.provision.NetworkPorts;
import com.yahoo.config.provision.NetworkPortsSerializer;
import com.yahoo.config.provision.NodeFlavors;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.slime.Cursor;
import com.yahoo.slime.Inspector;
import com.yahoo.slime.Slime;
import com.yahoo.vespa.config.SlimeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class AllocatedHosts {
    private static final String mappingKey = "mapping";
    private static final String hostSpecKey = "hostSpec";
    private static final String hostSpecHostNameKey = "hostName";
    private static final String aliasesKey = "aliases";
    private static final String hostSpecMembershipKey = "membership";
    private static final String flavorKey = "flavor";
    private static final String resourcesKey = "resources";
    private static final String vcpuKey = "vcpu";
    private static final String memoryKey = "memory";
    private static final String diskKey = "disk";
    private static final String diskSpeedKey = "diskSpeed";
    private static final String hostSpecVespaVersionKey = "vespaVersion";
    private static final String hostSpecCurrentVespaVersionKey = "currentVespaVersion";
    private static final String hostSpecNetworkPortsKey = "ports";
    private final ImmutableSet<HostSpec> hosts;

    AllocatedHosts(Set<HostSpec> hosts) {
        this.hosts = ImmutableSet.copyOf(hosts);
    }

    public static AllocatedHosts withHosts(Set<HostSpec> hosts) {
        return new AllocatedHosts(hosts);
    }

    private void toSlime(Cursor cursor) {
        Cursor array = cursor.setArray(mappingKey);
        for (HostSpec host : this.hosts) {
            this.toSlime(host, array.addObject().setObject(hostSpecKey));
        }
    }

    private void toSlime(HostSpec host, Cursor cursor) {
        cursor.setString(hostSpecHostNameKey, host.hostname());
        this.aliasesToSlime(host, cursor);
        host.membership().ifPresent(membership -> {
            cursor.setString(hostSpecMembershipKey, membership.stringValue());
            cursor.setString(hostSpecVespaVersionKey, membership.cluster().vespaVersion().toFullString());
        });
        host.flavor().ifPresent(flavor -> this.toSlime((Flavor)flavor, cursor));
        host.version().ifPresent(version -> cursor.setString(hostSpecCurrentVespaVersionKey, version.toFullString()));
        host.networkPorts().ifPresent(ports -> NetworkPortsSerializer.toSlime(ports, cursor.setArray(hostSpecNetworkPortsKey)));
    }

    private void aliasesToSlime(HostSpec spec, Cursor cursor) {
        if (spec.aliases().isEmpty()) {
            return;
        }
        Cursor aliases = cursor.setArray(aliasesKey);
        for (String alias : spec.aliases()) {
            aliases.addString(alias);
        }
    }

    private void toSlime(Flavor flavor, Cursor object) {
        if (flavor.isConfigured()) {
            object.setString(flavorKey, flavor.name());
        } else {
            NodeResources resources = flavor.resources();
            Cursor resourcesObject = object.setObject(resourcesKey);
            resourcesObject.setDouble(vcpuKey, resources.vcpu());
            resourcesObject.setDouble(memoryKey, resources.memoryGb());
            resourcesObject.setDouble(diskKey, resources.diskGb());
            resourcesObject.setString(diskSpeedKey, AllocatedHosts.diskSpeedToString(resources.diskSpeed()));
        }
    }

    public Set<HostSpec> getHosts() {
        return this.hosts;
    }

    private static AllocatedHosts fromSlime(Inspector inspector, Optional<NodeFlavors> nodeFlavors) {
        Inspector array = inspector.field(mappingKey);
        LinkedHashSet<HostSpec> hosts = new LinkedHashSet<HostSpec>();
        array.traverse((i, host) -> hosts.add(AllocatedHosts.hostFromSlime(host.field(hostSpecKey), nodeFlavors)));
        return new AllocatedHosts(hosts);
    }

    static HostSpec hostFromSlime(Inspector object, Optional<NodeFlavors> nodeFlavors) {
        Optional<ClusterMembership> membership = object.field(hostSpecMembershipKey).valid() ? Optional.of(AllocatedHosts.membershipFromSlime(object)) : Optional.empty();
        Optional<Flavor> flavor = AllocatedHosts.flavorFromSlime(object, nodeFlavors);
        Optional<Version> version = AllocatedHosts.optionalString(object.field(hostSpecCurrentVespaVersionKey)).map(Version::new);
        Optional<NetworkPorts> networkPorts = NetworkPortsSerializer.fromSlime(object.field(hostSpecNetworkPortsKey));
        return new HostSpec(object.field(hostSpecHostNameKey).asString(), AllocatedHosts.aliasesFromSlime(object), flavor, membership, version, networkPorts);
    }

    private static List<String> aliasesFromSlime(Inspector object) {
        if (!object.field(aliasesKey).valid()) {
            return Collections.emptyList();
        }
        ArrayList<String> aliases = new ArrayList<String>();
        object.field(aliasesKey).traverse((index, alias) -> aliases.add(alias.asString()));
        return aliases;
    }

    private static Optional<Flavor> flavorFromSlime(Inspector object, Optional<NodeFlavors> nodeFlavors) {
        if (object.field(flavorKey).valid() && nodeFlavors.isPresent() && nodeFlavors.get().exists(object.field(flavorKey).asString())) {
            return nodeFlavors.get().getFlavor(object.field(flavorKey).asString());
        }
        if (object.field(resourcesKey).valid()) {
            Inspector resources = object.field(resourcesKey);
            return Optional.of(new Flavor(new NodeResources(resources.field(vcpuKey).asDouble(), resources.field(memoryKey).asDouble(), resources.field(diskKey).asDouble(), AllocatedHosts.diskSpeedFromSlime(resources.field(diskSpeedKey)))));
        }
        return Optional.empty();
    }

    private static NodeResources.DiskSpeed diskSpeedFromSlime(Inspector diskSpeed) {
        if (!diskSpeed.valid()) {
            return NodeResources.DiskSpeed.fast;
        }
        switch (diskSpeed.asString()) {
            case "fast": {
                return NodeResources.DiskSpeed.fast;
            }
            case "slow": {
                return NodeResources.DiskSpeed.slow;
            }
            case "any": {
                return NodeResources.DiskSpeed.any;
            }
        }
        throw new IllegalStateException("Illegal disk-speed value '" + diskSpeed.asString() + "'");
    }

    private static String diskSpeedToString(NodeResources.DiskSpeed diskSpeed) {
        switch (diskSpeed) {
            case fast: {
                return "fast";
            }
            case slow: {
                return "slow";
            }
            case any: {
                return "any";
            }
        }
        throw new IllegalStateException("Illegal disk-speed value '" + diskSpeed + "'");
    }

    private static ClusterMembership membershipFromSlime(Inspector object) {
        return ClusterMembership.from(object.field(hostSpecMembershipKey).asString(), Version.fromString((String)object.field(hostSpecVespaVersionKey).asString()));
    }

    private static Optional<String> optionalString(Inspector inspector) {
        if (!inspector.valid()) {
            return Optional.empty();
        }
        return Optional.of(inspector.asString());
    }

    public byte[] toJson() throws IOException {
        Slime slime = new Slime();
        this.toSlime(slime.setObject());
        return SlimeUtils.toJsonBytes((Slime)slime);
    }

    public static AllocatedHosts fromJson(byte[] json, Optional<NodeFlavors> nodeFlavors) {
        return AllocatedHosts.fromSlime((Inspector)SlimeUtils.jsonToSlime((byte[])json).get(), nodeFlavors);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AllocatedHosts)) {
            return false;
        }
        return ((AllocatedHosts)other).hosts.equals(this.hosts);
    }

    public int hashCode() {
        return this.hosts.hashCode();
    }

    public String toString() {
        return this.hosts.toString();
    }
}

