/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision.zone;

import com.yahoo.config.provision.CloudName;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.RegionName;
import java.util.Objects;

public class ZoneId {
    private final Environment environment;
    private final RegionName region;
    private final CloudName cloud;

    private ZoneId(Environment environment, RegionName region, CloudName cloud) {
        this.environment = Objects.requireNonNull(environment, "environment must be non-null");
        this.region = Objects.requireNonNull(region, "region must be non-null");
        this.cloud = Objects.requireNonNull(cloud, "cloud must be non-null");
    }

    private ZoneId(Environment environment, RegionName region) {
        this(environment, region, CloudName.defaultName());
    }

    public static ZoneId from(Environment environment, RegionName region) {
        return new ZoneId(environment, region);
    }

    public static ZoneId from(String environment, String region) {
        return ZoneId.from(Environment.from(environment), RegionName.from(region));
    }

    public static ZoneId from(String value) {
        String[] parts = value.split("\\.");
        return ZoneId.from(parts[0], parts[1]);
    }

    public static ZoneId from(Environment environment, RegionName region, CloudName cloud) {
        return new ZoneId(environment, region, cloud);
    }

    public static ZoneId from(String environment, String region, String cloud) {
        return new ZoneId(Environment.from(environment), RegionName.from(region), CloudName.from(cloud));
    }

    public Environment environment() {
        return this.environment;
    }

    public RegionName region() {
        return this.region;
    }

    public CloudName cloud() {
        return this.cloud;
    }

    public String value() {
        return this.environment + "." + this.region;
    }

    public String toString() {
        return "zone " + this.value() + " in " + this.cloud;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZoneId zoneId = (ZoneId)o;
        return this.environment == zoneId.environment && Objects.equals(this.region, zoneId.region);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.environment, this.region});
    }
}

